import json
import copy
import csv
from collections import OrderedDict
import argparse
import os

total_score = {}
max_score = {}
min_score = {}
review = []
author = []

parser = argparse.ArgumentParser()
parser.add_argument('-m', '--file', default='fig1')
args = parser.parse_args()

file = args.file

with open(file, 'r') as f:
    for line in f:
        review.append(json.loads(line))



skill_dict = {}
cnt=0
for index, item in enumerate(review):
    # if len(item["score"])!=3:
    #     print("length issue!!!", item["score"], item )
    for key, skill in item["metrics"].items():
        skill_elem = skill[0].lower()
        score = item["score"][key]
        if score == 'yes':
            score = 1
        elif score == 'no':
            score = 0
        if skill_elem.split(' ')[0] not in skill_dict.keys():
            if 'logical' in skill_elem:
                # print(skill_elem)
                try:
                    if skill_elem.split(' ')[1] not in skill_dict:
                        print(skill_elem)
                        skill_dict[skill_elem.split(' ')[1]]=[0,0]
                except:
                    print(file, skill_elem, index)
            else:
                print(skill_elem)
                skill_dict[skill_elem.split(' ')[0]]=[0,0]
        if item["score"][key] == "N/A":
            cnt+=1
        else: 
            if 'logical' in skill_elem:
                try:
                    skill_dict[skill_elem.split(' ')[1]][0]+=float(score)
                    skill_dict[skill_elem.split(' ')[1]][1]+=1
                except:
                    print(file,score, skill_elem, 1)
            else: 
                try: 
                    skill_dict[skill_elem.split(' ')[0]][0]+=float(score)
                    skill_dict[skill_elem.split(' ')[0]][1]+=1
                except:
                    print(file, score, "@@")

key_order = ["robustness", "correctness", "efficiency", "factuality", "commonsense", "comprehension", "insightfulness", "completeness",  "metacognition","readability", "conciseness", "harmlessness"]
ordered_dict = OrderedDict((key, skill_dict[key]) for key in key_order if key in skill_dict)

file_name = file.split('/')[1].split('.jsonl')[0]

file_directory = 'outputs/stats/'
output_directory = os.path.dirname(file_directory)

# Check if the directory exists, if not, create it
if not os.path.exists(output_directory):
    os.makedirs(output_directory)

with open(file_directory+file_name+"_skill.csv", "w") as f1: 
    write = csv.writer(f1)
    write.writerow(["skill", "score", "count", "avg", "normalize"])
    for key, dict in ordered_dict.items():
        list = dict
        write.writerow([key, str(list[0]), str(list[1]), str(list[0]/list[1]), str(1+ 4*(list[0]/list[1]))])