import json
import os
import re
import re
import ast
import logging
import random
import sys
import csv
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)
def get_json_list(file_path):
    file_path = os.path.expanduser(file_path)
    file_extension = file_path.split('.')[-1]
    if file_extension=="jsonl":
        with open(file_path, 'r') as f:
            json_list = []
            for line in f:
                json_list.append(json.loads(line))
            return json_list
    else:
        with open(file_path, 'r') as f:
            return json.load(f)
def parse(review, subquestion_index_dict):
    try:
        match = re.findall(r'{[^}]+}', review)
        if len(match)>0:
            
            dictionary_part = match[-1].replace("\n", "").replace('_', " ").lower()
            lines = ast.literal_eval(dictionary_part)
            for key, value in lines.items():
                if type(value)!=list:
                    lines[key] = []
            score_dict = {}
            for key, value in lines.items():
                key = int(key)
                if 1<=key and key <=5:
                    score_dict[subquestion_index_dict[key-1]]=value
            return score_dict
        else:
            return {}


    except Exception as e:
        logger.error(f'{e}\nContent: {review}\n'
                     'You must manually fix the score pair.')
        return []
reviews = []
for model in ["bard_review_hard", "chatgpt_review_hard","davinci_003_review_hard", "claude_v1_review_hard", "gpt4_review_hard"]:
    reviews.append(get_json_list(model+".jsonl"))
for q_id in [60, 86, 27, 76, 12, 40, 46, 54]:
    for model_review in reviews:
        review = model_review[q_id-1]
        list_value = []
        for value in list(review["score"].values()):
            if value=="yes":
                list_value.append(1)
            elif value=="no":
                list_value.append(0)
            else:
                list_value.append("")  
        print(list_value)  
    print('...........')
        # print(q_id, list(review["score"].keys()), list(review["score"].values()))
                

