import json
import os
import re
import re
import ast
import logging
import random

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)
def get_json_list(file_path):
    file_path = os.path.expanduser(file_path)
    file_extension = file_path.split('.')[-1]
    if file_extension=="jsonl":
        with open(file_path, 'r') as f:
            json_list = []
            for line in f:
                json_list.append(json.loads(line))
            return json_list
    else:
        with open(file_path, 'r') as f:
            return json.load(f)
def parse(review, subquestion_index_dict):
    try:
        match = re.findall(r'{[^}]+}', review)
        if len(match)>0:
            
            dictionary_part = match[-1].replace("\n", "").replace('_', " ").lower()
            lines = ast.literal_eval(dictionary_part)
            for key, value in lines.items():
                if type(value)!=list:
                    lines[key] = []
            score_dict = {}
            for key, value in lines.items():
                key = int(key)
                if 1<=key and key <=5:
                    score_dict[subquestion_index_dict[key-1]]=value
            return score_dict
        else:
            return {}


    except Exception as e:
        logger.error(f'{e}\nContent: {review}\n'
                     'You must manually fix the score pair.')
        return []

review = get_json_list("flask_subquestion_skillset_annotation_old.jsonl")
with open("flask_subquestion_skillset_annotation.jsonl", "w") as f:
    for obj in review:
        obj["metrics"] = parse(obj["metric_explanation"], obj["subquestions"])
        f.write(json.dumps(obj) + '\n')