import json
import random, os
from glob import glob
import tqdm
MAX_SHOTS = 5
ADDRESS = "C:\\Users\\saurasrivastava\\Downloads\\BIG-bench-main\\bigbench\\benchmark_tasks\\list_functions"

def create_shots(dataset, task_prefix, output_function):
    new_dataset = {}
    random_indices = random.sample(range(0, len(dataset)), MAX_SHOTS)
    random_datasets = [(dataset[x], x) for x in random_indices]
    validation_datasets = [data for x, data in enumerate(dataset) if x not in random_indices]#fixed now :)
    for shot in range(MAX_SHOTS):
        n_shot_examples = random_datasets[:(shot + 1)]
        data = task_prefix + "\nExamples:\n"
        for example in n_shot_examples:
            example, example_index = example[0], example[1]
            data += "Input : " + example["input"] + "\n"
            data += "Output : " + example["target"] + "\n\n"
        new_dataset[shot] = {"train_prompt": data, "validation_examples": validation_datasets, "gold_function":output_function}
    return new_dataset
        
manual_prompt = "Write a python function after analyzing all of the following inputs and outputs as examples."
def read_all_directories(directory_address):
    all_dirs = os.listdir(directory_address)
    for _, dir in tqdm.tqdm(enumerate(all_dirs), desc = "Preparing datasets ...", total = len(all_dirs)):
        task_id = dir
        current_address = os.path.join(directory_address, dir)
        if(not os.path.isdir(current_address) or dir == "results"):
            continue
        task_json = json.load(open(os.path.join(current_address, "task.json")))
        n_shot_data = create_shots(task_json["examples"], task_json["task_prefix"], task_json["description"])
        for shot in n_shot_data:
            with open(os.path.join(current_address, f"default_{shot+1}_shot.json"), "w") as f:
                json.dump(n_shot_data[shot], f, indent = 4)

if __name__ == "__main__":
    read_all_directories(ADDRESS)
