import os, json
import tiktoken
PATH = "F:/user-repos/saurasrivastava/prompt_gen"
PATH_DATA = f"{PATH}/data"

def create_prompt():
    f = open(f"{PATH_DATA}/bad.txt", encoding="utf-8")
    bad_examples = [lines for lines in f]

    # take separate files, merge turn into combined prompts

    f = open(f"{PATH_DATA}/good.txt", encoding="utf-8")
    good_examples = [lines for lines in f]


    f = open(f"{PATH_DATA}/prompt_type.txt", encoding="utf-8")
    prompt_types = [lines for lines in f]

    f = open(f"{PATH_DATA}/reasons_for_good_bad.txt", encoding="utf-8")
    reasons = [lines for lines in f]

    # this contains the instruction part of the prompt - the other files comprise the exemplars
    f = open(f"{PATH_DATA}/general_guidelines.txt", encoding="utf-8")
    guidelines = '\n'.join([lines.strip() for lines in f])
    #print(guidelines)
    guidelines += "\n\n###Examples###\n\n"

    # single set of guidelines
    for ge, be, re, pt in zip(good_examples, bad_examples, reasons, prompt_types):
        test_string =  "###Candidate Prompt###\n" + be
        test_string += "###Reason###\n" + re 
        test_string += "###Better Prompt Type###\n" + pt
        test_string += "###Better Prompt###\n" + ge + "\n"    
        guidelines += test_string

    print(guidelines)

    # byte pair encoding (BPE)
    enc = tiktoken.encoding_for_model("gpt-4")


    guidelines_len = len(enc.encode(guidelines))

    test_prompt = input("Please enter the prompt you want to test: ")
    # test_prompt = """
    # The odd numbers in this group add up to an even number: 15, 32, 5, 13, 82, 7, 1
    # """
    example_template = f"""
    ###Candidate Prompt### 
    {test_prompt}  
    ###Reason### 
    """
    f = open(f"{PATH_DATA}/output_prompt.txt", 'w', encoding="utf-8")
    f.write(guidelines + example_template)
    f.close()
    return  guidelines + example_template



if __name__ == "__main__":
    create_prompt()
