import json, os
import pandas as pd



PATH = "/Volumes/Academic/Projects/PRoMTd"
PATH_DATA = f"{PATH}/outputs"


def read_big_bench(big_bench_address):
    return json.load(open(big_bench_address))["examples"]


def json_to_csv(dataset_name, dataset_file, gold_dataset):
    jsn = json.load(open("outputs/analytical_entailment_gpt-3.5-turbo_final.json"))
    overall_data = []
    for id in jsn:
        all_attempts = jsn[id]["all_attempts"]
        question = jsn[id]["question"]
        print(jsn[id].keys())
        final_response = jsn[id]["final_response"]
        ground_truth_output = gold_dataset[int(id)]["target_scores"]
        overall_data.append([id, question, all_attempts[0], final_response[0], all_attempts[1], final_response[1], all_attempts[2], final_response[2], ground_truth_output])
    df = pd.DataFrame(overall_data, columns = ["id", "question", "attempt_1", "response_1", "attempt_2", "response_2", "attempt_3", "response_3", "ground_truth_output"])
    df.to_csv(os.path.join(PATH_DATA, dataset_name, dataset_name + ".csv"), index = False)


if __name__ == "__main__":
    dataset = read_big_bench("./data/analytical_entailment/analytical_entailment.json")
    json_to_csv("analytical_entailment", "analytical_entailment_final.json", dataset)
    
