

# run prompt on all of the original examples??

import pandas as pd
import openai, os, json
import tiktoken

from langchain.chat_models import AzureChatOpenAI
from langchain import LLMChain

PATH = "F:/user-repos/saurasrivastava/prompt_gen"
PATH_DATA = f"{PATH}/data"

delimiter = "###Better Prompt###"



# read the output prompt lines (the prompt classes) and assemble as string
# output_prompt.txt has:
#    guidelines
#    instructions
#    all examples, in format: candidate (bad) prompt, bad prompt reason, prompt type, 
#       better prompt

# read in guidelines, instructions, examples
prompt = [lines for lines in open(f'{PATH_DATA}/output_prompt.txt', encoding = "utf-8")]
#print(''.join(prompt).encode('utf_8','strict'))
prompt = ''.join(prompt)

enc = tiktoken.encoding_for_model("gpt-4")

guidelines_len = len(enc.encode(prompt))
# token count, just of guidelines
print("Length of guidelines: ", guidelines_len)



# get predictions on all examples?
#response = llm.predict(''.join(prompt))
response = llm.predict(prompt)
print(response)
prompt = prompt.strip()
# split between better prompt and all prior
reason, better_prompt = response.split(delimiter)
reason, better_prompt = reason.strip(), better_prompt.strip()
# further split out prompt type
reason, prompt_type = reason.split("###Better Prompt Type###")
reason, prompt_type = reason.strip(), prompt_type.strip()
# original prompt very long - don't include in output
output_dict = {"Reason":reason, 
               "Better Prompt":better_prompt, 
               "Output Prompt Type": prompt_type}

#print(json.dumps(output_dict, indent = 4))

with open(f"{PATH_DATA}/output_prompt_results.txt", "w") as f:
    json.dump(output_dict, f, indent=4)
