import traceback
from flask_mail import Mail, Message
import datetime
import copy
from email import message
from enum import unique

from datetime import datetime
import json
import os, sys, re

from flask import Flask, render_template, request, redirect, url_for, flash, jsonify
from flask_sqlalchemy import SQLAlchemy
from flask_wtf import FlaskForm
from wtforms import PasswordField, BooleanField, EmailField
from wtforms.validators import InputRequired, Email, Length
from flask_bootstrap import Bootstrap
from itsdangerous import URLSafeSerializer
from sqlalchemy.types import JSON
from flask import abort
from flask_login import LoginManager, login_user, login_required, logout_user, current_user
import ast
from flask_socketio import SocketIO, emit

# project-related prompting functions
from betterPromptCaller import get_better_prompt

app = Flask(__name__)
Bootstrap(app)
app.config["SECRET_KEY"] = "deloitte"
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///prompt_val_gen_db.db"

db = SQLAlchemy(app)

from routes import *
from models import User, Prompt

login_manager = LoginManager()
login_manager.init_app(app)
login_manager.login_view = "login"

PATH = "F:/user-repos/saurasrivastava/prompt_gen"
PATH_DATA = f"{PATH}/data"



@login_manager.user_loader
def load_user(user_id):
	return User.query.get(int(user_id))



if(os.path.exists("./instance/prompt_val_gen_db.db")):
	with app.app_context():
		if User.query.count() == 0:  # No user exists
			admin = User(username='admin@deloitte.com', admin=True, confirmed=True)
			admin.set_password('12345678')
			db.session.add(admin)
			db.session.commit()




if __name__ == "__main__":
	app.run(debug=True, 
		host="0.0.0.0", 
		port="1234", 
		threaded=True)
