#!/bin/bash

# Print usage if unspecified
if [ $# -le 1 ]; then
  echo "Expected arguments: <model> <cuda>"
  exit 1
fi
model=$1
cuda=$2
shift $#

# Loads in all relevant datasets
source ../../miniconda/bin/activate
conda activate ./venv

python mvce_dataset.py imagenet --output ./results/mvce-imagenet/ \
    --dataset '{ "path": "../../datasets/ImageNet", "sensor_size": 56 }' \
    --classifier "./models/imagenet/imagenet-$model.pklz" \
    --cuda_index $cuda --drop block-dropout \
    --zero_variance --beta_variance_scales 0.5 --probability_scales 10 --imputators "./models/mean/imagenet.pklz" \
    --action_spaces zero-one --threads 4 --trials 4