# MUSML

## Requirements
* python3
* pytorch 1.9.0
* yaml
* numpy, pandas
* also: GPU

## Preparing data
* meta-dataset: download from [HSML](https://github.com/huaxiuyao/HSML)
* MiniImagenet: downlaod from [Optimization as a Model for Few-shot Learning](https://github.com/markdtw/meta-learning-lstm-pytorch)

after downloaded all the datasets, put them in the data directory.
The directories structure in the `data` should be
* meta-dataset/
  * CUB_Bird/
  * DTD_Texture/
  * FGVC_Aircraft/
  * FGVCx_Fungi/
* mini-imagenet/
    * images/
    * split/

## 5way5shot for meta-datasets:
```bash
python MUSML.py --gpu_id 0 --k 20 --n_dim 5 --expt 5way5shot --ds MetaDataset
```

## 5way1shot for meta-datasets:
```bash
python MUSML.py --gpu_id 0 --k 5 --n_dim 5 --expt 5way1shot --ds MetaDataset
```

## 5way1shot for mini-imagenet:
```bash
python MUSML.py --gpu_id 0 --k 3 --n_dim 3 --expt 5way5shot --ds MINI_IMAGENET
```

## 5way1shot for mini-imagenet:
```bash
python MUSML.py --gpu_id 0 --k 2 --n_dim 3 --expt 5way1shot --ds MINI_IMAGENET
```
