# Function to prepare everything for this condition
def prep_condition(condition, folder_name, base_network):
    """
    :param condition: Which condition are we in
    :param folder_name: Name of data folder
    :param base_network: Name of base network
    :return:
    """

    # Set number of epochs depending on model family
    if base_network == "Res18":
        num_epochs = 90
        num_base_epochs = 90
    elif base_network == "Dense121":
        num_epochs = 30
        num_base_epochs = 30
    elif base_network == "VGG":
        num_epochs = 30
        num_base_epochs = 30
    else:
        raise Exception("No correct model family defined! Run script using: sbatch ./run_analysis MODELFAMILY")

    # Set number of models depending on condition
    if (condition.endswith("Base_condition") or condition.endswith("Different_batchsize")
            or condition.endswith("Different_optimizer") or condition.endswith("Different_architecture")
            or condition.endswith("Plus_1ep") or condition.endswith("Plus_10ep")
            or condition.endswith("Base_comparison")):
        num_models = 1
    elif condition.endswith("Different_data") or condition.endswith("Different_data_compared"):
        num_models = 2
    else:
        num_models = 5

    # For plus epoch conditions, set number of epochs higher
    if condition.endswith("Plus_1ep"):
        num_epochs += 1
    elif condition.endswith("Plus_10ep"):
        num_epochs += 10
    elif condition.endswith("Base_comparison"):
        num_epochs = 90

    # Add plus 1 to num_epochs and num_base_epochs because model is given test set once before training
    num_epochs += 1
    num_base_epochs += 1

    return num_epochs, num_models, num_base_epochs