import pandas as pd
import samplerate 
import numpy as np
import os
from glob import glob

all_files = sorted(glob('./UESTC-MMEA-CL/sensor/*/*.csv'))
for file_path in all_files:
    print(file_path)
    mpu_datas = pd.read_csv(file_path, header=None)[[0,1,2]]
    mpu_datas /= 8192
    
    new_sample0 = samplerate.resample(np.array(mpu_datas[0]), 30/25, 'sinc_best')
    new_sample1 = samplerate.resample(np.array(mpu_datas[1]), 30/25, 'sinc_best')
    new_sample2 = samplerate.resample(np.array(mpu_datas[2]), 30/25, 'sinc_best')
    
    new_sample = np.stack([new_sample0, new_sample1, new_sample2], axis=0)
    
    save_path = file_path.replace('sensor', 'accelerator')[:-4] + '.npy'
    if not os.path.exists(os.path.dirname(save_path)):
        os.makedirs(os.path.dirname(save_path))
        
    np.save(save_path, new_sample)



