# Relaxing Representation Alignment with Knowledge Preservation for Multi-Modal Continual Learning


## Setup

This implementation has been tested on Python 3.10, Ubuntu 22.04, CUDA 12.2. 

1. Refer to `requirements.txt` package versions
2. Refer to respective folders in `data` for instructions to prepare dataset
3. Refer to `pretrained` folder for instructions to prepare pretrained modality-specific encoders


## Training

Example: To run experiments of our method on AVE and KITCHEN:

```bash
# AVE
python3 -minclearn --options options/ours/ave.yaml \
    --dump-predictions --batch-size 16 --workers 8  \
    --device <gpu_id> --label ours_ave_T7_buffer100 --save-model never \
    --data-path <path_to_ave_dataset>

# KITCHEN
python3 -minclearn --options options/ours/kitchen.yaml \
    --dump-predictions --batch-size 16 --workers 8  \
    --device <gpu_id> --label ours_kitchen_T5_buffer100 --save-model never \
    --data-path <path_to_kitchen_dataset>
```

* To conduct experiments using other incremental learning methods or datasets, change the `--options` arguments in the command to the respective files for the method and dataset. 
* By default, no checkpoints will be saved. To save them after training of each task, add the argument `--save-model task`.


## Results

Your training and evaluation results can be found under the folder [results/dev](results/dev)
