#!/bin/bash
outputPath="$PWD/EPIC_KITCHENS"

if ! [ -x "$(command -v wget)" ]; then
    echo "Error!: wget is not installed! Please install it and try again"
    exit 1
fi

echo -e "\n### ------------------------------------------------------- ###\n"
echo "### Downloading into $outputPath"
echo -e "\n### ------------------------------------------------------- ###\n"

epic_download() {
    local url=$1
    local path=$2
    
    echo -ne "# Downloading "$url"\t"
    wget --progress=dot --continue --directory-prefix="$path" "$url" 2>&1 | grep --line-buffered "%" | sed -E "s,\.,,g" | awk '{printf("\b\b\b\b%4s", $2)}'
    echo -ne "\b\b\b\b"
    echo " # done"
}

# +
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_01.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_02.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_03.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_04.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_05.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_06.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_07.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_08.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_09.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_10.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_16.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_17.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_18.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P01/P01_19.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_102.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_103.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_104.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_105.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_106.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_107.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_108.tar" "$outputPath/rgb/train/P01" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P01/rgb_frames/P01_109.tar" "$outputPath/rgb/train/P01" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_01.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_02.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_03.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_04.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_05.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_06.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_07.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_08.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_09.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_10.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P02/P02_11.tar" "$outputPath/rgb/train/P02"
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_101.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_102.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_103.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_104.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_105.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_107.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_108.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_109.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_110.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_111.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_112.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_113.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_114.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_115.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_116.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_118.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_119.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_120.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_121.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_122.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_123.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_124.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_127.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_126.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_128.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_129.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_130.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_131.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_132.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_133.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_134.tar" "$outputPath/rgb/train/P02" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P02/rgb_frames/P02_135.tar" "$outputPath/rgb/train/P02" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_01.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_02.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_03.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_04.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_05.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_06.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_07.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_08.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_09.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_10.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_11.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_12.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_13.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_14.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_15.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_16.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_17.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_18.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_19.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_20.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_21.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_22.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P04/P04_23.tar" "$outputPath/rgb/train/P04"
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_101.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_102.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_103.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_104.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_106.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_107.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_108.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_109.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_110.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_111.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_112.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_113.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_114.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_115.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_116.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_117.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_118.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_119.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_120.tar" "$outputPath/rgb/train/P04" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P04/rgb_frames/P04_121.tar" "$outputPath/rgb/train/P04" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_05.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_06.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_07.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_08.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_09.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_10.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_11.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_12.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_13.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_14.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_15.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_16.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P22/P22_17.tar" "$outputPath/rgb/train/P22"
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_101.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_102.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_103.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_104.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_105.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_106.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_107.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_108.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_109.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_110.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_111.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_112.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_113.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_115.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_116.tar" "$outputPath/rgb/train/P22" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P22/rgb_frames/P22_117.tar" "$outputPath/rgb/train/P22" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_01.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_02.tar" "$outputPath/rgb/train/P30"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_03.tar" "$outputPath/rgb/train/P30"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_04.tar" "$outputPath/rgb/train/P30"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_05.tar" "$outputPath/rgb/train/P30"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_06.tar" "$outputPath/rgb/train/P30"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_10.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/train/P30/P30_11.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_101.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_102.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_103.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_104.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_107.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_108.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_109.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_110.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_111.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_112.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_113.tar" "$outputPath/rgb/train/P30" 
epic_download "https://data.bris.ac.uk/datasets/2g1n6qdydwa9u22shpxqzp0t8m/P30/rgb_frames/P30_114.tar" "$outputPath/rgb/train/P30" 


# +
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P01/P01_11.tar" "$outputPath/rgb/test/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P01/P01_12.tar" "$outputPath/rgb/test/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P01/P01_13.tar" "$outputPath/rgb/test/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P01/P01_14.tar" "$outputPath/rgb/test/P01" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P01/P01_15.tar" "$outputPath/rgb/test/P01" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P02/P02_12.tar" "$outputPath/rgb/test/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P02/P02_13.tar" "$outputPath/rgb/test/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P02/P02_14.tar" "$outputPath/rgb/test/P02"
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P02/P02_15.tar" "$outputPath/rgb/test/P02"

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_24.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_25.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_26.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_27.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_28.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_29.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_30.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_31.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_32.tar" "$outputPath/rgb/test/P04" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P04/P04_33.tar" "$outputPath/rgb/test/P04" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P22/P22_01.tar" "$outputPath/rgb/test/P22" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P22/P22_02.tar" "$outputPath/rgb/test/P22" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P22/P22_03.tar" "$outputPath/rgb/test/P22" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P22/P22_04.tar" "$outputPath/rgb/test/P22" 

epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P30/P30_07.tar" "$outputPath/rgb/test/P30" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P30/P30_08.tar" "$outputPath/rgb/test/P30" 
epic_download "https://data.bris.ac.uk/datasets/3h91syskeag572hl6tvuovwv4d/frames_rgb_flow/rgb/test/P30/P30_09.tar" "$outputPath/rgb/test/P30" 
# -


echo -e "\n### ------------------------------------------------------- ###\n"
echo "### All done!"
echo -e "\n### ------------------------------------------------------- ###\n"
