import os

def extract_frames(video, dst):
    cmd1 = 'ffmpeg '
    cmd1 += '-i ' + video + " "
    cmd1 += '-y' + " "
    cmd1 += "-qscale:v 4 " 
    cmd1 += '-r ' + "10 "
    cmd1 += '{0}/frame_%010d.jpg'.format(dst)

    print(cmd1)
    os.system(cmd1)


video_root = './UESTC-MMEA-CL/video/'

frame_root = './UESTC-MMEA-CL/rgb/'


if not os.path.exists(frame_root):
    os.makedirs(frame_root)

c_name_list = os.listdir(video_root)
for c_name in c_name_list:
    c_path = os.path.join(video_root, c_name)
    v_name_list = os.listdir(c_path)
    for v_name in v_name_list:
        v_id = v_name[:-4]
        v_path = os.path.join(c_path, v_name)
        dst_path = os.path.join(frame_root, c_name, v_id)
        if not os.path.exists(dst_path):
            os.makedirs(dst_path)
        print(dst_path)
        extract_frames(v_path, dst_path)
        print("finish video id: " + v_id)

