# Depth-Aware Adversarial Training (DAAT)
This repository is the offical implemention Depth-Aware Adversarial Training (DAAT).

### Installation

- Install `CUDA 11.3` with `cuDNN 8` following the official installation guide of [CUDA](https://docs.nvidia.com/cuda/cuda-installation-guide-linux/index.html) and [cuDNN](https://developer.nvidia.com/rdp/cudnn-archive).

- Setup conda environment:
```bash
# Create environment
conda create -n RobustBench python=3.9 -y
conda activate RobustBench

# Install requirements
conda install pytorch=1.12.1 torchvision=0.13.1 cudatoolkit=11.3 -c pytorch -y


# Install other requirements
pip install -r requirements.txt
```
The requirements.txt includes its dependencies.

## Registering the Model in `timm`
Before training or evaluating the code, you need to register the model with `timm`.

### Steps
1. Locate your local timm installation (e.g., within your virtual environment).
2. Open `timm/models/vision_transformer.py` (around line 758; the exact line may vary by version).
3. Add the following function definition:
```python
@register_model
def vit_base_patch14_224(pretrained: bool = False, **kwargs):
    """
    ViT-Base (ViT-B/16) from the original paper.
    ImageNet-1k weights fine-tuned from in21k @ 224x224.
    """
    model_kwargs = dict(patch_size=14, embed_dim=768, depth=12, num_heads=12, **kwargs)
    model = _create_vision_transformer('vit_base_patch14_224', pretrained=pretrained, **model_kwargs)
    return model
```
**Note**: Line numbers differ across `timm` versions. Ensure the `register_model` decorator is imported in the file (it usually is in `vision_transformer.py`). After editing, restart your Python session so the changes take effect.


## Category selection for Imagenet-100 
The selected catergories are listed in `classes_wnids.txt` which are randomly sampled from ImageNet-1K dataset. This process is following the open source-code https://github.com/danielchyeh/ImageNet-100-Pytorch. 

## Example to run the codes
    # Training
    python -m torch.distributed.launch --nproc_per_node=4 adversarial_training_our.py --configs=./train_configs/vit_base_patch14_224_imagenet100.yaml


    # Eval 
    python -m torch.distributed.launch --nproc_per_node=4 test.py --configs=./train_configs/test.yaml --ckpt_dir ./results/ImageNet-100_ours/vit_base_patch14_224_imagenet100/model_best.pth.tar

## Acknowledgments

  This repository builds upon code from the open-source projects [adversarial_training_imagenet](https://github.com/thu-ml/adversarial_training_imagenet) and [ARES-Bench](https://arxiv.org/abs/2302.14301). 
  We gratefully acknowledge and thank the authors and contributors of these projects for releasing their code and for their valuable contributions to robustness research.


