
## Setting up the environment
We adopt the original conda environment of `q-diffusion` (see their repo at github for setup instructions) 
```
conda env create -f environment.yml
conda activate qdiff_PixArt
```

but make some notable dependency changes:
```
pytorch==1.13.0+cu117
diffusers==0.29.2
transformers==4.42.3
accelerate==0.27.2
pytorch-fid==0.3.0
pytorch_lightning==1.5.0
networkx==3.1
sentencepiece
pycocotools
```

## Generating the calibration set.
To generate a calibration set, we need to download the MS-COCO 2017 dataset. Replace the hard-coded Path in the following two scripts.
The command to generate calibration data for PixArt alpha and sigma are:
```
python scripts/pixart_alpha_calib_ucs.py 
```
This will save files `pixart_calib_brecq.pt` containing the calibration data.

## Quantization

The basic command to calibrate PixArt alpha and generate 10k images using COCO prompt
```
python scripts/pixart_alpha_brecq.py --plms --cond --n_samples 1 --outdir <output_dir> --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_calib_brecq.pt --cali_batch_size 16 --cali_iters 2500 --cali_iters_a 1 --quant_act --act_bit <6 or 8> --act_mantissa_bits <3 for A6, 4 for A8> --weight_group_size 128 --weight_mantissa_bits 1 --ff_weight_mantissa 0 --res 512 --coco_10k 
```

## Advanced setting for ablation studies

We provide options in `pixart_alpha_brecq.py` for the sake of ablation studies. There are multiple ways to check the available options. We recommend two ways to check those options out:
1. use `-h` or `--help`.
2. Check from Line 320 to Line 383 of `pixart_alpha_brecq.py`.
The option setting is identical for alpha and sigma. Here we provide some commands we used to generate the ablation studies result in this paper. If you want to tailor an experiment, please refer to the help section or the code comments.

Using Origin AdaRound on FP format:
```
python scripts/pixart_alpha_brecq.py --plms --cond --n_samples 1 --outdir alpha_brecq_OriginAda_w4a16_2.5k_aug2 --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_calib_brecq.pt --cali_batch_size 16 --cali_iters 2500 <or any step you want> --weight_group_size 128 --ff_weight_mantissa 0 --weight_mantissa_bits 1 --no_fp_biased_adaround
```

Using Origin AdaRound on INT format (E0M3):
```
python scripts/pixart_alpha_brecq.py --plms --cond --n_samples 1 --outdir alpha_brecq_INTAda_w4a16_2.5k_aug2 --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_calib_brecq.pt --cali_batch_size 16 --cali_iters 20000 --weight_group_size 128 --weight_mantissa_bits 3 --no_fp_biased_adaround
```

Our mix FP format strategy not using AdaRound but use direct minmax weight quantization
```
python scripts/pixart_alpha_brecq.py --plms --cond --n_samples 1 --outdir FF_W4G128_E1M2_ffE0M3_noada_aug2 --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_calib_brecq.pt --cali_batch_size 16 --cali_iters 2500 --no_adaround --weight_group_size 128 --ff_weight_mantissa 0 --weight_mantissa_bits 1
```

Our suboptimal FP format strategy (all E2M1) not using AdaRound but use direct minmax weight quantization
```
python scripts/pixart_alpha_brecq.py --plms --cond --n_samples 1 --outdir FF_W4G128_E1M2_ffE1M2_noada_aug2 --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_calib_brecq.pt --cali_batch_size 16 --cali_iters 2500 --no_adaround --weight_group_size 128 --ff_weight_mantissa 1 --weight_mantissa_bits 1
```

## Seed
All seeds are default set as 42. If you want to change it, use --seed <112312 any number>