
## Setting up the environment
We adopt the original conda environment of `q-diffusion` (see their repo at github for setup instructions) 
```
conda env create -f environment.yml
conda activate qdiff_PixArt
```

but make some notable dependency changes:
```
pytorch==1.13.0+cu117
diffusers==0.29.2
transformers==4.42.3
accelerate==0.27.2
pytorch-fid==0.3.0
pytorch_lightning==1.5.0
networkx==3.1
sentencepiece
pycocotools
```

## Generating the calibration set.
To generate a calibration set, we need to download the MS-COCO 2017 dataset. Replace the hard-coded Path in the following two scripts.
The command to generate calibration data for PixArt alpha and sigma are:
```
python scripts/pixart_sigma_calib.py 
```
This will save `pixart_sigma_calib_brecq.pt` containing the calibration data.

## Quantization

The command to calibrate PixArt sigma and generate 10k images using COCO prompt
```
python scripts/pixart_sigma_brecq.py --plms --cond --n_samples 1 --outdir <output_dir> --ptq --weight_bit 4 --quant_mode qdiff --cond --cali_data_path pixart_sigma_calib_brecq.pt --cali_batch_size 16 --cali_iters 2500 --cali_iters_a 1 --quant_act --act_bit <6 or 8> --act_mantissa_bits <3 for A6, 4 for A8> --weight_group_size 128 --weight_mantissa_bits 2 --ff_weight_mantissa 0 --coco_10k --res 1024
```

## Advanced setting for ablation studies

Please refer to PixArt alpha's code for ablation studies

## Seed
All seeds are default set as 42. If you want to change it, use --seed <112312 any number>