## Train Toy
```
python train.py --problem_name {dataset1}_to_{dataset2} --exp {experiment_name} --batch_size 200 --num_iterations 120000 --beta1 0 --use_ema --lr_scheduler --time_sample uniform --tau 0.1 --lmbda 10
```

## Train Male2Female 64x64
```
python train.py --problem_name male_to_female --image_size 64 --exp {experiment_name} --batch_size 64 --num_iterations 60000 --beta1 0 --use_ema --lr_scheduler --time_sample uniform --tau 0.001 --lmbda 10
```

## Train Wild2Cat 64x64
```
python train.py --problem_name male_to_female --image_size 64 --exp {experiment_name} --batch_size 64 --num_iterations 60000 --beta1 0 --use_ema --lr_scheduler --time_sample uniform --tau 0.0005 --lmbda 10
```

## Train Male2Female 128x128
```
python train.py --problem_name male_to_female --image_size 128 --exp {experiment_name} --batch_size 64 --num_iterations 100000 --beta1 0 --use_ema --lr_scheduler --time_sample uniform --num_channels_dae 64 --n_mlp 3 --ch_mult 1 1 2 2 4 4 --ema_decay 0.999 --tau 0.001 --lmbda 10
```

## How to generate fid

- Go to data/dataset.py and change line 15:
```
ROOT_PATH = "./data" -> ROOT_PATH = "./"
```
- Then, go to the "Make FID stats" cell of 'test.ipynb' file.
- Put appropriate 'data_name' (str), 'image_size' (int), 'train' (bool) and run it!

## How should you put I2I Dataset
Suppose you would like to transport ```data1``` (with data name ```dataname1```) into ```data2``` (with data name ```dataname2```).
Then, make directory ```data/{dataname1}2{dataname2}/```, then put every train data of ```data1``` and ```data2``` in ```data1``` in ```data/{dataname1}2{dataname2}/trainA``` and ```data/{dataname1}2{dataname2}/trainB```, respectively. Moreover, put every test data  of ```data1``` and ```data2``` in ```data1``` in ```data/{dataname1}2{dataname2}/testA``` and ```data/{dataname1}2{dataname2}/testB```, respectively.