# -*- coding: utf-8 -*-
import torch
import json

import torch.nn as nn
from layers.SSNet_layers import SSNet


class Model(nn.Module):

    def __init__(self, configs):
        super(Model, self).__init__()
        self.task_name = configs.task_name
        self.seq_len = configs.seq_len
        self.pred_len = configs.pred_len
        self.n_vars = configs.enc_in
        self.top_k = configs.top_k
        data_name = configs.data_path.replace(".csv", "").split("/")[-1]
        self.max_lag = self.seq_len // 2
        auto_correlation = json.load(open(f"autocorr_{self.max_lag}.json", "r"))
        period_strength = {}
        self.top_k = min(self.top_k, len(auto_correlation[data_name]["significant_periods"]))
        for i in range(self.top_k):
            period = auto_correlation[data_name]["significant_periods"][i]
            strength = auto_correlation[data_name]["period_strength"][i]
            period_strength[period] = strength
        period_strength = sorted(period_strength.items(), key=lambda x: x[0])

        self.period = [x[0] for x in period_strength]
        self.strength = [x[1] for x in period_strength]
        print("period: ", self.period)
        print("strength: ", self.strength)

        self.encoder = SSNet(
            seq_len=self.seq_len,
            pred_len=self.pred_len,
            n_vars=self.n_vars,
            hidden_size=configs.d_model,
            periods=self.period,
            period_strength=self.strength,
            dropout=configs.dropout,
            channel_independence=configs.channel_independence
        )

    def forecast(self, x_enc, x_mark_enc, x_dec, x_mark_dec):
        # Normalization from Non-stationary Transformer
        means = x_enc.mean(1, keepdim=True).detach()
        x_enc = x_enc - means
        stdev = torch.sqrt(
            torch.var(x_enc, dim=1, keepdim=True, unbiased=False) + 1e-5)
        x_enc /= stdev

        x_enc = x_enc.permute(0, 2, 1)
        # dec_out, season, trend = self.encoder(x_enc)
        dec_out = self.encoder(x_enc)
        dec_out = dec_out.permute(0, 2, 1)

        # De-Normalization from Non-stationary Transformer
        dec_out = dec_out * \
                  (stdev[:, 0, :].unsqueeze(1).repeat(1, self.pred_len, 1))
        dec_out = dec_out + \
                  (means[:, 0, :].unsqueeze(1).repeat(1, self.pred_len, 1))
        return dec_out


    def forward(self, x_enc, x_mark_enc, x_dec, x_mark_dec, mask=None):
        if self.task_name == 'long_term_forecast' or self.task_name == 'short_term_forecast':
            dec_out = self.forecast(x_enc, x_mark_enc, x_dec, x_mark_dec)
            return dec_out[:, -self.pred_len:, :]  # [B, L, D]
