
model_name='FITS'
gpu_id=7
data_name='ETTh1'
des='FITS'

seq_len=512
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
    python3 -u run.py \
    --random_seed 2021 \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name'_96_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --enc_in 7 \
    --des $des \
    --H_order 6 \
    --train_epochs 100\
    --patience 20 \
    --itr 1 \
    --batch_size 64 \
    --num_workers 0 \
    --learning_rate 0.0005
done
