#conda activate py38

model_name='Koopa'
gpu_id=0
data_name='ETTm1'
des='Koopa'

seq_len=512
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
    python3 -u run.py \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name'_96_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --seg_len 256  \
    --dynamic_dim 64 \
    --hidden_dim 512 \
    --hidden_layers 2 \
    --num_blocks 4 \
    --train_epochs 100 \
    --patience 20 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 7 \
    --des $des \
    --learning_rate 0.001 \
    --itr 1 \
    --num_workers 0
done

