
model_name='ModernTCN'
gpu_id=7
data_name='ETTh2'
des='ModernTCN'

seq_len=96
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
  python3 -u run.py \
  --is_training 1 \
  --model_id $data_name \
  --model $model_name \
  --root_path ./dataset/ETT-small/ \
  --data_path $data_name.csv \
  --data $data_name \
  --features M \
  --seq_len $seq_len \
  --pred_len $pred_len \
  --ffn_ratio 1 \
  --patch_size 8 \
  --patch_stride 4 \
  --num_blocks 1 \
  --large_size 51 \
  --small_size 5 \
  --dims 64 64 64 64 \
  --head_dropout 0.0 \
  --enc_in 7 \
  --dropout 0.3 \
  --itr 1 \
  --train_epochs 100 \
  --batch_size 512 \
  --patience 20 \
  --learning_rate 0.0001 \
  --des Exp \
  --lradj type3 \
  --use_multi_scale False \
  --small_kernel_merged False
done
