#conda activate py38

model_name='SSNet'
gpu_id=7

data_name='electricity'
des='SSNet'
data_name='electricity'
seq_len=512
pred_lens=(
  96
  192
  336
  720
)


export CUDA_VISIBLE_DEVICES=$gpu_id
for j in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$j]}
  echo '======================'$data_name'_'$pred_len'======================'
  python -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --top_k 5 \
    --channel_independence 0 \
    --root_path ./dataset/electricity/ \
    --data_path $data_name.csv \
    --model_id $ECL'_96_'$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --enc_in 321 \
    --d_model 128 \
    --dropout 0.1 \
    --train_epochs 100\
    --patience 100\
    --des $des \
    --itr 1 \
    --batch_size 64 \
    --pct_start 0.2 \
    --lradj 'TST'\
    --num_workers 0 \
    --learning_rate 0.001
done

