#conda activate py38

model_name='SSNet'
gpu_id=0

des='SSNet'
data_name='traffic'
seq_len=512
pred_lens=(
  96
  192
  336
  720
)


export CUDA_VISIBLE_DEVICES=$gpu_id
for j in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$j]}
  echo '======================'$data_name'_'$pred_len'======================'
  CUDA_VISIBLE_DEVICES=$gpu_id
  python -u run.py \
    --task_name long_term_forecast \
    --top_k 10 \
    --is_training 1 \
    --root_path ./dataset/traffic/ \
    --data_path $data_name.csv \
    --model_id $ECL'_96_'$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --enc_in 862 \
    --d_model 128 \
    --dropout 0.02 \
    --train_epochs 100\
    --patience 20\
    --des $des \
    --itr 1 \
    --lradj 'TST' \
    --batch_size 24 \
    --pct_start 0.4 \
    --num_workers 0 \
    --learning_rate 0.002
done
