#conda activate py38

model_name='CrossGNN'
gpu_id=7
data_name='ETTh1'
des='CrossGNN'

seq_len=336
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
  python3 -u run.py \
    --random_seed 2021 \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name'_96_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --e_layers 1 \
    --enc_in 7 \
    --c_out 7 \
    --train_epochs 100\
    --patience 20\
    --des $des \
    --itr 1 \
    --batch_size 32 \
    --num_workers 0 \
    --lradj 'type1' \
    --learning_rate 0.01
done
