#conda activate py38

model_name='iTransformer'
gpu_id=6
data_name='ETTh2'
des='iTransformer'

seq_len=512
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
  python3 -u run.py \
    --random_seed 2021 \
    --task_name long_term_forecast \
    --channel_independence 0 \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name'_96_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --e_layers 2 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 7 \
    --des $des \
    --d_model 128 \
    --d_ff 128 \
    --itr 1 \
    --train_epochs 100\
    --patience 20\
    --num_workers 0
done
