#conda activate py38

model_name='SSNet'
gpu_id=0
data_name='ETTm1'
des='SSNet'

seq_len=96
pred_lens=(
  96
  192
  336
  720
)

export CUDA_VISIBLE_DEVICES=$gpu_id
for i in ${!pred_lens[@]}; do
  pred_len=${pred_lens[$i]}
  echo '======================'$data_name'_'$pred_len'======================'
  python3 -u run.py \
    --task_name long_term_forecast \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path $data_name.csv \
    --model_id $data_name'_96_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --enc_in 7 \
    --c_out 7 \
    --top_k 10 \
    --d_model 128 \
    --dropout 0.8  \
    --train_epochs 100\
    --patience 20\
    --des $des \
    --itr 1 \
    --batch_size 2048 \
    --lradj 'TST'\
    --pct_start 0.1 \
    --num_workers 0 \
    --learning_rate 0.005
done
