#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import matplotlib.pyplot as plt
from matplotlib.ticker import FormatStrFormatter
import matplotlib
import numpy as np

#===================================================================================================
plt.rcParams["lines.markersize"] = 20
plt.rcParams["lines.linewidth"] = 4
plt.rcParams["font.size"] = 27
#===================================================================================================
matplotlib.rcParams['font.family'] = 'sans-serif'
matplotlib.rcParams['font.sans-serif'] = ['DejaVu Sans']
matplotlib.rcParams['mathtext.fontset'] = 'cm'
#===================================================================================================
legend_font_size = 22
#===================================================================================================
mark_mult = 30
#=========================================================================================================================
markevery = [m * mark_mult for m in [2, 3, 2, 3, 2, 3, 2, 3, 2]]
marker = ["d","v","*","D","o","*", "x","^","*"]
#marker = [None, None, None, None, None, None, None, None, None]

color = ["#e41a1c", "#377eb8", "#4daf4a", "#35978f", "#ff7f00", "#ffff33", "#a65628", "#878787", "#999999"]
linestyle = ["solid", "solid", "solid", "solid","solid","solid", "solid", "solid", "solid"]
#=========================================================================================================================
fig = plt.figure(figsize=(12, 9))
ax = fig.add_subplot(1, 1, 1)
index = 0

d = np.linspace(1, 1000.0, num=1000)

for k in [1,5,10,50,100]:
    a = k/d
    one_minus_a = 1 - a
    theta = 1 - (one_minus_a)**0.5
    beta = one_minus_a / (1 - one_minus_a**0.5)
    beta_over_theta = beta/theta
    #print(beta_over_theta[0])
    ax.plot(d, beta_over_theta**0.5, color=color[index], marker=marker[index], markevery=markevery[index], linestyle=linestyle[index], label=f"Top{k}")
    index += 1

ax.set_xlabel('Dimension $d$', fontdict = {'fontsize':35})
ax.set_ylabel('$\\sqrt{ \\dfrac{\\beta}{\\theta} }$', fontdict = {'fontsize':35})
ax.yaxis.set_major_formatter(FormatStrFormatter('%.2g'))
#ax.set_title(f"Dataset: {dataset},d={d},n={nClients},$\\lambda$={lambda_regul}")
ax.grid(True)
ax.legend(loc='best', fontsize = legend_font_size)
plt.xticks(fontsize=27)
plt.yticks(fontsize=30)
fig.tight_layout()

plt.show()
