# How to Launch experiments for the paper: 

# "Improved Theory for Error Feedback: From Quadratic to Arithmetic Mean of Smoothness Constants"

## Prerequisites

The experiments for the paper **"Improved Theory for Error Feedback: From Quadratic to Arithmetic Mean of Smoothness Constants"**. 

Experiments were constructed by modifying FL_PyTorch [https://arxiv.org/abs/2202.03099](https://arxiv.org/abs/2202.03099), [GitHub link](https://github.com/burlachenkok/flpytorch) simulation tool.

The first step is preparing the environment.  Preparation of environment described in [README.md](https://github.com/burlachenkok/flpytorch/blob/main/README.md) files of this publicly available repository.

If you have installed the [conda](https://docs.conda.io/en/latest/) environment and package manager then you should perform only the following steps for preparing the environment:

```
conda create -n fl python=3.9.1 -y
conda install -n fl pytorch"=1.10.0" torchvision numpy cudatoolkit"=11.1" h5py"=3.6.0" coloredlogs matplotlib psutil pyqt pytest pdoc3 wandb -c pytorch -c nvidia -c conda-forge -y
conda activate fl
```

Our experiments have been carried out utilizing computation only in CPU. Our modification of the simulator is located in [./fl_pytorch](fl_pytorch). 

Please use this version that we're providing instead of the Open Source version.

## The place with Execution Command Lines for launch experiments

The next directories contain a command line for launching the computation work:

### Experiments with synthetic datasets
* [./fl_pytorch/show_topk.py](./fl_pytorch/show_topk.py) - Experiment for section **Practical Role of Improvement for EF21**. It demonstrates dependence $\sqrt{\beta/\theta}$ as a function of dimension $d$ for fixed compressor TopK with $K$ equal to $1, 5, 10, 50, 100$.
* [./fl_pytorch/launch_scripts/full_synthetics](./fl_pytorch/launch_scripts/full_synthetics) - Experiments for **EF21** and **EF21-W** Algorithms in sythetic datasets.
* [./fl_pytorch/launch_scripts/pp_synthetics](./fl_pytorch/launch_scripts/pp_synthetics) - Experiments for **EF21-PP** and **EF21-W-PP** Algorithms sythetic datasets.

### Experiments with several LIBSVM datasets

* [./fl_pytorch/launch_scripts/full_libsvm](./fl_pytorch/launch_scripts/full_libsvm) - Experiments for **EF21** and **EF21-W** Algorithms for LIBSVM real datasets.
* [./fl_pytorch/launch_scripts/pp_libsvm](./fl_pytorch/launch_scripts/pp_libsvm) - Experiments for **EF21-PP** and **EF21-W-PP** Algorithms in LIBSVM datasets.
* [./fl_pytorch/launch_scripts/sgd_libsvm](./fl_pytorch/launch_scripts/sgd_libsvm) - Experiments for **EF21-SGD** and **EF21-W-SGD** Algorithms in LIBSVM datasets.

### Experiments with stepsize multipliers and utilizing Natural compressor
* [./fl_pytorch/launch_scripts/full_australian_step_size_mult](./fl_pytorch/launch_scripts/full_australian_step_size_mult) - Experiments for **EF21** and **EF21-W** Algorithms for AUSTRALIAN real datasets.

## Visualization of the Results: Standalone

Result binary files can be loaded into the simulator [./fl_pytorch/fl_pytorch/gui/start.py](./fl_pytorch/fl_pytorch/gui/start.py). After this plots can be visualized in the *Analysis* tab. Recommendations on how to achieve this are available in [TUTORIAL.md](https://github.com/burlachenkok/flpytorch/blob/main/TUTORIAL.md) provided with [flpytorch](https://github.com/burlachenkok/flpytorch) simulator.

## Visualization of the Results: Online

If you want to use the [WandB](https://wandb.ai/settings) online tool to track the progress of the numerical experiments please specify:
* `--wandb-key "xxxxxxxxxxx" ` with a key from your wandb profile: [https://wandb.ai/settings](https://wandb.ai/settings)
* `--wandb-project-name "vvvvvvvvvv"` with a project name that you're planning to use.

You should replace `--wandb-project-name "vvvvvvvvvv"` with a project name that you're planning to use or leave the default name. These keys should be replaced manually inside launched scripts if you're interested in WandB support.
