import os, sys
import numpy as np
import pandas as pd
import time
import json
import openai
import datasets
import argparse
from tqdm import tqdm

# openai.api_key = ''

def generate_answer(answer_context, model = 'gpt3.5-06'):
    if model == 'gpt3.5-06':
        model_str = 'gpt-3.5-turbo-0613'
    elif model == 'ft-gpt3.5':
        model_str = 'ft:gpt-3.5-turbo-0613:torralbalab:5k-fin-a4-r3-10:80OjcnDI'
    else:
        model_str = 'gpt-4-0613'
    try:
        completion = openai.ChatCompletion.create(
                  model=model_str,
                  messages=answer_context,
                  n=1)
    except:
        print('retrying due to an error......')
        time.sleep(20)
        return generate_answer(answer_context)
    return completion

def construct_assistant_message(completion):
    content = completion['choices'][0]['message']['content']
    return {'role': 'assistant', 'content': content}

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--model', action = 'store', default = 'gpt3.5-06', choices = ['gpt4', 'ft-gpt3.5', 'gpt3.5-06'])
    parser.add_argument('--file', action = 'store', default = 'ft-gpt35-5k-epochs10_alpaca_leaderboard')
    args = parser.parse_args()
    eval_set = datasets.load_dataset('tatsu-lab/alpaca_eval', 'alpaca_eval')['eval']
    response_dict = {}
    print(len(eval_set))
    for example in eval_set:
        instruction = example['instruction']
        agent_context = [[{'role': 'user', 'content': instruction}]]
        completion = generate_answer(agent_context[0], args.model)
        print(completion)
        agent_context[0].append(construct_assistant_message(completion))
        response_dict[instruction] = agent_context
    if not os.path.exists('leaderboard_eval'):
        os.makedirs('leaderboard_eval')
    with open(f'leaderboard_eval/{args.file}.json', 'w') as f:
        json.dump(response_dict, f)