import os
import json
import pickle
import pandas as pd
import argparse

def post_pickle(pickle_data):
    one_model_outputs = []
    debate_model_outputs = []
    for prompt in pickle_data:
        new_prompt = prompt
        one_response_dict = {'instruction': new_prompt}
        debate_response_dict = {'instruction': new_prompt}
        full_output = pickle_data[prompt][0]
        one_agent_response = full_output[1]['content'] ##First agent, second response
        debate_response = full_output[-1]['content'] ##First agent, final response (after debate)
        one_response_dict['output'] = one_agent_response
        debate_response_dict['output'] = debate_response
        one_model_outputs.append(one_response_dict)
        debate_model_outputs.append(debate_response_dict)
    return one_model_outputs, debate_model_outputs

def read_samp_data(json_path, pickle_data):
    alpaca_df = pd.read_json(json_path)
    alpaca_df['prompt'] = (alpaca_df['instruction'] + ' ' + alpaca_df['input']).apply(str.rstrip)
    prompts = list(pickle_data.keys())
    alpaca_df = alpaca_df[alpaca_df['prompt'].isin(prompts)].reset_index(drop = True)
    return alpaca_df

def post_df(alpaca_df):
    gpt_outputs = []
    for i in alpaca_df.index:
        prompt = alpaca_df.iloc[i]['prompt']
        output = alpaca_df.iloc[i]['output']
        gpt_outputs.append({'instruction': prompt, 'output': output})
    return gpt_outputs

if __name__ == '__main__':
    with open('leaderboard_eval/ft-gpt35-5k-epochs10_alpaca_leaderboard.json', 'r') as f:
        pickle_data = json.load(f)

    one_model_outputs, debate_model_outputs = post_pickle(pickle_data)
    with open('model_jsons/ft-gpt35-5k-epochs10_alpaca_leaderboard.json', 'w') as f:
        json.dump(debate_model_outputs, f)

    post_df(debate_model_outputs)