DEFAULT_ACOUSTIC_MATERIAL_COEFF_MAPPING = {
    'Default': {'absorption': [20.0, 0.10000000149011612, 20000.0, 0.10000000149011612],
                'scattering': [20.0, 0.5, 20000.0, 0.5], 'transmission': [20.0, 0.0, 20000.0, 0.0]},
    'Acoustic Tile': {
        'absorption': [125.0, 0.5, 250.0, 0.699999988079071, 500.0, 0.6000000238418579, 1000.0, 0.699999988079071,
                       2000.0, 0.699999988079071, 4000.0, 0.5],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.15000000596046448, 500.0, 0.20000000298023224, 1000.0,
                       0.20000000298023224, 2000.0, 0.25, 4000.0, 0.30000001192092896],
        'transmission': [125.0, 0.05000000074505806, 250.0, 0.03999999910593033, 500.0, 0.029999999329447746, 1000.0,
                         0.019999999552965164, 2000.0, 0.004999999888241291, 4000.0, 0.0020000000949949026]},
    'Brick': {
        'absorption': [125.0, 0.019999999552965164, 250.0, 0.019999999552965164, 500.0, 0.029999999329447746, 1000.0,
                       0.03999999910593033, 2000.0, 0.05000000074505806, 4000.0, 0.07000000029802322],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.25, 500.0, 0.30000001192092896, 1000.0, 0.3499999940395355,
                       2000.0, 0.4000000059604645, 4000.0, 0.44999998807907104],
        'transmission': [125.0, 0.02500000037252903, 250.0, 0.01899999938905239, 500.0, 0.009999999776482582, 1000.0,
                         0.0044999998062849045, 2000.0, 0.0017999999690800905, 4000.0, 0.008899999782443047]},
    'Brick, Painted': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.009999999776482582, 500.0, 0.019999999552965164, 1000.0,
                       0.019999999552965164, 2000.0, 0.019999999552965164, 4000.0, 0.029999999329447746],
        'scattering': [125.0, 0.15000000596046448, 250.0, 0.15000000596046448, 500.0, 0.20000000298023224, 1000.0,
                       0.20000000298023224, 2000.0, 0.20000000298023224, 4000.0, 0.25],
        'transmission': [125.0, 0.02500000037252903, 250.0, 0.01899999938905239, 500.0, 0.009999999776482582, 1000.0,
                         0.0044999998062849045, 2000.0, 0.0017999999690800905, 4000.0, 0.008899999782443047]},
    'Carpet': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.05000000074505806, 500.0, 0.10000000149011612, 1000.0,
                       0.20000000298023224, 2000.0, 0.44999998807907104, 4000.0, 0.6499999761581421],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.15000000596046448, 1000.0,
                       0.20000000298023224, 2000.0, 0.30000001192092896, 4000.0, 0.44999998807907104],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Carpet, Heavy': {
        'absorption': [125.0, 0.019999999552965164, 250.0, 0.05999999865889549, 500.0, 0.14000000059604645, 1000.0,
                       0.3700000047683716, 2000.0, 0.47999998927116394, 4000.0, 0.6299999952316284],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.15000000596046448, 500.0, 0.20000000298023224, 1000.0, 0.25,
                       2000.0, 0.3499999940395355, 4000.0, 0.5],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Carpet, Heavy Padded': {
        'absorption': [125.0, 0.07999999821186066, 250.0, 0.23999999463558197, 500.0, 0.5699999928474426, 1000.0,
                       0.6899999976158142, 2000.0, 0.7099999785423279, 4000.0, 0.7300000190734863],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.15000000596046448, 500.0, 0.20000000298023224, 1000.0, 0.25,
                       2000.0, 0.3499999940395355, 4000.0, 0.5],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Tile, Ceramic': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.009999999776482582, 500.0, 0.009999999776482582, 1000.0,
                       0.009999999776482582, 2000.0, 0.019999999552965164, 4000.0, 0.019999999552965164],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.11999999731779099, 500.0, 0.14000000059604645, 1000.0,
                       0.1599999964237213, 2000.0, 0.18000000715255737, 4000.0, 0.20000000298023224],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Concrete': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.009999999776482582, 500.0, 0.009999999776482582, 1000.0,
                       0.019999999552965164, 2000.0, 0.019999999552965164, 4000.0, 0.019999999552965164],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10999999940395355, 500.0, 0.11999999731779099, 1000.0,
                       0.12999999523162842, 2000.0, 0.14000000059604645, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Concrete, Rough': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.019999999552965164, 500.0, 0.03999999910593033, 1000.0,
                       0.05999999865889549, 2000.0, 0.07999999821186066, 4000.0, 0.10000000149011612],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.11999999731779099, 500.0, 0.15000000596046448, 1000.0,
                       0.20000000298023224, 2000.0, 0.25, 4000.0, 0.30000001192092896],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]},
    'Concrete Block': {
        'absorption': [125.0, 0.36000001430511475, 250.0, 0.4399999976158142, 500.0, 0.3100000023841858, 1000.0,
                       0.28999999165534973, 2000.0, 0.38999998569488525, 4000.0, 0.20999999344348907],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.11999999731779099, 500.0, 0.15000000596046448, 1000.0,
                       0.20000000298023224, 2000.0, 0.30000001192092896, 4000.0, 0.4000000059604645],
        'transmission': [125.0, 0.019999999552965164, 250.0, 0.009999999776482582, 500.0, 0.006300000008195639, 1000.0,
                         0.0035000001080334187, 2000.0, 0.0010999999940395355, 4000.0, 0.0006000000284984708]},
    'Concrete Block, Painted': {
        'absorption': [125.0, 0.10000000149011612, 250.0, 0.05000000074505806, 500.0, 0.05999999865889549, 1000.0,
                       0.07000000029802322, 2000.0, 0.09000000357627869, 4000.0, 0.07999999821186066],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10999999940395355, 500.0, 0.12999999523162842, 1000.0,
                       0.15000000596046448, 2000.0, 0.1599999964237213, 4000.0, 0.20000000298023224],
        'transmission': [125.0, 0.019999999552965164, 250.0, 0.009999999776482582, 500.0, 0.006300000008195639, 1000.0,
                         0.0035000001080334187, 2000.0, 0.0010999999940395355, 4000.0, 0.0006000000284984708]},
    'Curtain': {
        'absorption': [125.0, 0.07000000029802322, 250.0, 0.3100000023841858, 500.0, 0.49000000953674316, 1000.0, 0.75,
                       2000.0, 0.699999988079071, 4000.0, 0.6000000238418579],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.15000000596046448, 500.0, 0.20000000298023224, 1000.0,
                       0.30000001192092896, 2000.0, 0.4000000059604645, 4000.0, 0.5],
        'transmission': [125.0, 0.41999998688697815, 250.0, 0.38999998569488525, 500.0, 0.20999999344348907, 1000.0,
                         0.14000000059604645, 2000.0, 0.07900000363588333, 4000.0, 0.04500000178813934]},
    'Foliage': {
        'absorption': [125.0, 0.029999999329447746, 250.0, 0.05999999865889549, 500.0, 0.10999999940395355, 1000.0,
                       0.17000000178813934, 2000.0, 0.27000001072883606, 4000.0, 0.3100000023841858],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.30000001192092896, 500.0, 0.4000000059604645, 1000.0, 0.5,
                       2000.0, 0.699999988079071, 4000.0, 0.800000011920929],
        'transmission': [125.0, 0.8999999761581421, 250.0, 0.8999999761581421, 500.0, 0.8999999761581421, 1000.0,
                         0.800000011920929, 2000.0, 0.5, 4000.0, 0.30000001192092896]},
    'Glass': {
        'absorption': [125.0, 0.3499999940395355, 250.0, 0.25, 500.0, 0.18000000715255737, 1000.0, 0.11999999731779099,
                       2000.0, 0.07000000029802322, 4000.0, 0.05000000074505806],
        'scattering': [125.0, 0.05000000074505806, 250.0, 0.05000000074505806, 500.0, 0.05000000074505806, 1000.0,
                       0.05000000074505806, 2000.0, 0.05000000074505806, 4000.0, 0.05000000074505806],
        'transmission': [125.0, 0.125, 250.0, 0.08900000154972076, 500.0, 0.05000000074505806, 1000.0,
                         0.02800000086426735, 2000.0, 0.02199999988079071, 4000.0, 0.07900000363588333]},
    'Glass, Heavy': {
        'absorption': [125.0, 0.18000000715255737, 250.0, 0.05999999865889549, 500.0, 0.03999999910593033, 1000.0,
                       0.029999999329447746, 2000.0, 0.019999999552965164, 4000.0, 0.019999999552965164],
        'scattering': [125.0, 0.05000000074505806, 250.0, 0.05000000074505806, 500.0, 0.05000000074505806, 1000.0,
                       0.05000000074505806, 2000.0, 0.05000000074505806, 4000.0, 0.05000000074505806],
        'transmission': [125.0, 0.0560000017285347, 250.0, 0.039000000804662704, 500.0, 0.02800000086426735, 1000.0,
                         0.019999999552965164, 2000.0, 0.03200000151991844, 4000.0, 0.014000000432133675]},
    'Grass': {
        'absorption': [125.0, 0.10999999940395355, 250.0, 0.25999999046325684, 500.0, 0.6000000238418579, 1000.0,
                       0.6899999976158142, 2000.0, 0.9200000166893005, 4000.0, 0.9900000095367432],
        'scattering': [125.0, 0.30000001192092896, 250.0, 0.30000001192092896, 500.0, 0.4000000059604645, 1000.0, 0.5,
                       2000.0, 0.6000000238418579, 4000.0, 0.699999988079071],
        'transmission': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0]},
    'Gravel': {
        'absorption': [125.0, 0.25, 250.0, 0.6000000238418579, 500.0, 0.6499999761581421, 1000.0, 0.699999988079071,
                       2000.0, 0.75, 4000.0, 0.800000011920929],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.30000001192092896, 500.0, 0.4000000059604645, 1000.0, 0.5,
                       2000.0, 0.6000000238418579, 4000.0, 0.699999988079071],
        'transmission': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0]},
    'Gypsum Board': {
        'absorption': [125.0, 0.28999999165534973, 250.0, 0.10000000149011612, 500.0, 0.05000000074505806, 1000.0,
                       0.03999999910593033, 2000.0, 0.07000000029802322, 4000.0, 0.09000000357627869],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10999999940395355, 500.0, 0.11999999731779099, 1000.0,
                       0.12999999523162842, 2000.0, 0.14000000059604645, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.03500000014901161, 250.0, 0.012500000186264515, 500.0, 0.00559999980032444, 1000.0,
                         0.0024999999441206455, 2000.0, 0.0013000000035390258, 4000.0, 0.0031999999191612005]},
    'Plaster on Brick': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.019999999552965164, 500.0, 0.019999999552965164, 1000.0,
                       0.029999999329447746, 2000.0, 0.03999999910593033, 4000.0, 0.05000000074505806],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.25, 500.0, 0.30000001192092896, 1000.0, 0.3499999940395355,
                       2000.0, 0.4000000059604645, 4000.0, 0.44999998807907104],
        'transmission': [125.0, 0.02500000037252903, 250.0, 0.01899999938905239, 500.0, 0.009999999776482582, 1000.0,
                         0.0044999998062849045, 2000.0, 0.0017999999690800905, 4000.0, 0.0008900000248104334]},
    'Plaster on Concrete Block': {
        'absorption': [125.0, 0.11999999731779099, 250.0, 0.09000000357627869, 500.0, 0.07000000029802322, 1000.0,
                       0.05000000074505806, 2000.0, 0.05000000074505806, 4000.0, 0.03999999910593033],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.25, 500.0, 0.30000001192092896, 1000.0, 0.3499999940395355,
                       2000.0, 0.4000000059604645, 4000.0, 0.44999998807907104],
        'transmission': [125.0, 0.019999999552965164, 250.0, 0.009999999776482582, 500.0, 0.006300000008195639, 1000.0,
                         0.0035000001080334187, 2000.0, 0.00011000000085914508, 4000.0, 0.0006300000241026282]},
    'Soil': {
        'absorption': [125.0, 0.15000000596046448, 250.0, 0.25, 500.0, 0.4000000059604645, 1000.0, 0.550000011920929,
                       2000.0, 0.6000000238418579, 4000.0, 0.6000000238418579],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.20000000298023224, 500.0, 0.25, 1000.0, 0.4000000059604645,
                       2000.0, 0.550000011920929, 4000.0, 0.699999988079071],
        'transmission': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0]},
    'Sound Proof': {'absorption': [125.0, 1.0, 250.0, 1.0, 500.0, 1.0, 1000.0, 1.0, 2000.0, 1.0, 4000.0, 1.0],
                    'scattering': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0],
                    'transmission': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0]},
    'Snow': {
        'absorption': [125.0, 0.44999998807907104, 250.0, 0.75, 500.0, 0.8999999761581421, 1000.0, 0.949999988079071,
                       2000.0, 0.949999988079071, 4000.0, 0.949999988079071],
        'scattering': [125.0, 0.20000000298023224, 250.0, 0.30000001192092896, 500.0, 0.4000000059604645, 1000.0, 0.5,
                       2000.0, 0.6000000238418579, 4000.0, 0.699999988079071],
        'transmission': [125.0, 0.0, 250.0, 0.0, 500.0, 0.0, 1000.0, 0.0, 2000.0, 0.0, 4000.0, 0.0]},
    'Steel': {
        'absorption': [125.0, 0.05000000074505806, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.07000000029802322, 4000.0, 0.019999999552965164],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.10000000149011612, 4000.0, 0.10000000149011612],
        'transmission': [125.0, 0.25, 250.0, 0.20000000298023224, 500.0, 0.17000000178813934, 1000.0,
                         0.08900000154972076, 2000.0, 0.08900000154972076, 4000.0, 0.0560000017285347]},
    'Water': {
        'absorption': [125.0, 0.009999999776482582, 250.0, 0.009999999776482582, 500.0, 0.009999999776482582, 1000.0,
                       0.019999999552965164, 2000.0, 0.019999999552965164, 4000.0, 0.029999999329447746],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.07000000029802322, 2000.0, 0.05000000074505806, 4000.0, 0.05000000074505806],
        'transmission': [125.0, 0.029999999329447746, 250.0, 0.029999999329447746, 500.0, 0.029999999329447746, 1000.0,
                         0.019999999552965164, 2000.0, 0.014999999664723873, 4000.0, 0.009999999776482582]},
    'wood, Thin': {
        'absorption': [125.0, 0.41999998688697815, 250.0, 0.20999999344348907, 500.0, 0.10000000149011612, 1000.0,
                       0.07999999821186066, 2000.0, 0.05999999865889549, 4000.0, 0.05999999865889549],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.10000000149011612, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.20000000298023224, 250.0, 0.125, 500.0, 0.07900000363588333, 1000.0,
                         0.10000000149011612, 2000.0, 0.08900000154972076, 4000.0, 0.05000000074505806]},
    'wood, Thick': {
        'absorption': [125.0, 0.1899999976158142, 250.0, 0.14000000059604645, 500.0, 0.09000000357627869, 1000.0,
                       0.05999999865889549, 2000.0, 0.05999999865889549, 4000.0, 0.05000000074505806],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.10000000149011612, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.03500000014901161, 250.0, 0.02800000086426735, 500.0, 0.02800000086426735, 1000.0,
                         0.02800000086426735, 2000.0, 0.0010999999940395355, 4000.0, 0.0071000000461936]},
    'Wood Floor': {
        'absorption': [125.0, 0.15000000596046448, 250.0, 0.10999999940395355, 500.0, 0.10000000149011612, 1000.0,
                       0.07000000029802322, 2000.0, 0.05999999865889549, 4000.0, 0.07000000029802322],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.10000000149011612, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.07100000232458115, 250.0, 0.02500000037252903, 500.0, 0.015799999237060547, 1000.0,
                         0.00559999980032444, 2000.0, 0.0035000001080334187, 4000.0, 0.0015999999595806003]},
    'Wood On Concrete': {
        'absorption': [125.0, 0.03999999910593033, 250.0, 0.03999999910593033, 500.0, 0.07000000029802322, 1000.0,
                       0.05999999865889549, 2000.0, 0.05999999865889549, 4000.0, 0.07000000029802322],
        'scattering': [125.0, 0.10000000149011612, 250.0, 0.10000000149011612, 500.0, 0.10000000149011612, 1000.0,
                       0.10000000149011612, 2000.0, 0.10000000149011612, 4000.0, 0.15000000596046448],
        'transmission': [125.0, 0.004000000189989805, 250.0, 0.007899999618530273, 500.0, 0.00559999980032444, 1000.0,
                         0.0015999999595806003, 2000.0, 0.00139999995008111, 4000.0, 0.0005000000237487257]}}

DEFAULT_DENSITY = 998.6546630859375
DEFAULT_SPEED = 1483.9610595703125
DEFAULT_DAMPING = [
    22.27947998046875, 1.1595274046483084e-10, 27.647445678710938, 1.7855866785154717e-10,
    34.30875778198242, 2.7496721566322435e-10, 42.57503890991211, 4.234294304072961e-10,
    52.832969665527344, 6.520501361073627e-10, 65.56243896484375, 1.0041096842883235e-09,
    81.35887908935547, 1.5462540137178848e-09, 100.9613265991211, 2.3811186355970904e-09,
    125.2867431640625, 3.6667489045072443e-09, 155.47299194335938, 5.646519696256291e-09,
    192.93234252929688, 8.695229425370599e-09, 239.4170684814453, 1.3390017095105122e-08,
    297.1015930175781, 2.0619632223883855e-08, 368.6846618652344, 3.175273022293368e-08,
    457.5147705078125, 4.8896882987037316e-08, 567.7471923828125, 7.529756373969576e-08,
    704.5390625, 1.1595275850595499e-07, 874.288818359375, 1.7855860789950384e-07,
    1084.938232421875, 2.749672489699151e-07, 1346.341064453125, 4.234294976868114e-07,
    1670.724853515625, 6.520498345707892e-07, 2073.265869140625, 1.0041092082246905e-06,
    2572.79443359375, 1.546254907225375e-06, 3192.6767578125, 2.381117610639194e-06,
    3961.915771484375, 3.666750899355975e-06, 4916.4892578125, 5.64652327739168e-06,
    6101.05517578125, 8.695225915289484e-06, 7571.03466796875, 1.3390024832915515e-05,
    9395.1796875, 2.0619641873054206e-05, 11658.830078125, 3.175271558575332e-05,
    14467.8916015625, 4.889691263088025e-05, 17953.748046875, 7.529760478064418e-05
]