
def get_data(config):
    if config.name == "alpaca_eval":
        from llm_router.data.alpaca_eval import AlpacaEval
        return AlpacaEval(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    elif config.name == "helm_lite":
        from llm_router.data.helm_lite import HELMLite
        return HELMLite(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    elif config.name == "helm_mmlu":
        from llm_router.data.helm_mmlu import HELMMMLU
        return HELMMMLU(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    elif config.name == "openllm2":
        from llm_router.data.openllm2 import OpenLLM2
        return OpenLLM2(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    elif config.name == "routerbench":
        from llm_router.data.routerbench import RouterBench
        return RouterBench(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    elif config.name == "vhelm":
        from llm_router.data.vhelm import VHELM
        return VHELM(config.data_file, config.embed_file, config.routing_config, config.split, config.seed)
    else:
        raise NotImplementedError()