import random

from llm_router.router.base_router import BaseRouter, RouterInput, RouterOutput, PREFERENCES
from llm_router.data.utils import get_costs

class RandomRouter(BaseRouter):
    
    @property
    def name(self):
        return f"random_router"
    
    def fit(self, trianset, valset, configs):
        pass
    
    def route(self, router_input: RouterInput):
        outputs = {}
        for preference in PREFERENCES:
            routing_id = random.choice(range(len(router_input.scores)))
            routing_model = list(router_input.routing_config.keys())[routing_id]
            outputs[preference] = RouterOutput(
                idx=router_input.idx,
                routing_config=router_input.routing_config,
                scores=router_input.scores,
                costs=router_input.costs,
                input_tokens=router_input.input_tokens,
                output_tokens=router_input.output_tokens,
                routing_id=routing_id,
                routing_model=routing_model,
                info={},
            )
            
        return outputs