
def get_router(config):
    if config.name == "oracle":
        from llm_router.router.oracle_router import OracleRouter
        return OracleRouter(config)
    elif config.name == "random":
        from llm_router.router.random_router import RandomRouter
        return RandomRouter(config)
    elif config.name == "knn_pred":
        from llm_router.router.knn_pred_router import KNNPredictorRouter
        return KNNPredictorRouter(config)
    elif config.name == "linear_pred":
        from llm_router.router.linear_pred_router import LinearPredictorRouter
        return LinearPredictorRouter(config)
    elif config.name == "mlp_pred":
        from llm_router.router.mlp_pred_router import MLPPredictorRouter
        return MLPPredictorRouter(config)
    elif config.name == "pred":
        from llm_router.router.pred_router import PredRouter
        return PredRouter(config)
    elif config.name == "knn_cls":
        from llm_router.router.knn_cls_router import KNNClassifierRouter
        return KNNClassifierRouter(config)
    elif config.name == "linear_cls":
        from llm_router.router.linear_cls_router import LinearClassifierRouter
        return LinearClassifierRouter(config)
    elif config.name == "mlp_cls":
        from llm_router.router.mlp_cls_router import MLPClassifierRouter
        return MLPClassifierRouter(config)
    elif config.name == "cls":
        from llm_router.router.cls_router import ClsRouter
        return ClsRouter(config)
    else:
        raise NotImplementedError()