# Coherence-free Entrywise Estimation of Eigenvectors in Low-rank Signal-plus-noise Matrix Models


This repository is the official implementation of Coherence-free Entrywise Estimation of Eigenvectors in Low-rank Signal-plus-noise Matrix Models.

## Requirements:

To install requirements:

~~~bash
```setup
pip install -r requirements.txt
```
~~~

## Simulations

To run the rank-one simulation with a particular combination of conditions , run this command:
	```python3 run.py n 1 a noise u_scheme```

To run the rank-r simulation for `r > 1`  with a particular combination of conditions, run this command:
	```python3 run.py n r a noise```

- `n`: matrix dimension.
- `r`: matrix rank, to run the rank-one simulation, set `r=1`. 
- `a`: largest entry magnitude, taking values in the interval `(0,1)`.
- `noise`: noise type, `1` for Gaussian, `2` for Laplacian, and `3` for Rademacher.
- `u_scheme`: scheme to generate the ground truth signal eigenvector, taking binary values in the set `{0,1}`,  `0` for Bernoulli scheme and `1` for Haar scheme. When `r != 1`, `u_scheme` is set to `1` and the user cannot specify it.

### Example 1.

```{python}
>>> python3 run.py 1000 1 0.8 2 1
Infty Estimation Error:
      n  r    a      noise haar Ours.Error Spec.Error
0  1000  1  0.8  Laplacian  Yes     0.0507     0.0507
Estimation Error of the Largest Entry:
      n  r    a      noise haar  largest.loc  U.largest Ours.Est Spec.Est Ours.Error Spec.Error
0  1000  1  0.8  Laplacian  Yes          547        0.8   0.8014   0.7497     0.0014     0.0503
```

### Example 2.

```{python}
>>> python3 run.py 1000 2 0.8 3
Infty Estimation Error:
      n  r    a  k       noise Ours.Error Spec.Error
0  1000  2  0.8  0  Rademacher     0.0220     0.0257
1  1000  2  0.8  1  Rademacher     0.0346     0.0535
Estimation Error of the Largest Entry:
      n  r    a  k       noise  largest.loc U.largest Ours.Est Spec.Est Ours.Error Spec.Error
0  1000  2  0.8  0  Rademacher          184    0.8000  -0.7998  -0.7743     0.0002     0.0257
1  1000  2  0.8  1  Rademacher           96    0.8004  -0.7972  -0.7469     0.0032     0.0535
Two-to-Infty Estimation Error:
      n  r    a       noise Ours.Error Spec.Error
0  1000  2  0.8  Rademacher     0.0377     0.0536
```



