from COH1 import simulator as simulator_1
from COHR import simulator as simulator_r
import sys
import pandas as pd

USAGE='USAGE: python %s n r a noise [u_scheme]' % sys.argv[0]

if __name__ == "__main__":
    if len( sys.argv ) < 5: # Fewer than four command line arguments
        raise RuntimeError( USAGE )
    n = int(sys.argv[1])
    if n < 1:
        raise RuntimeError( 'Matrix size n must be a positive integer.' )
    r = int(sys.argv[2])
    if r < 1:
        raise RuntimeError( 'Signal rank r must be a positive integer.' )
    a = float(sys.argv[3])
    if a < 0.0 or a > 1.0:
        raise RuntimeError( 'Coherence a must be between 0 and 1.' )
    noise = int(sys.argv[4])
    if noise not in [1,2,3]:
        raise RuntimeError('noise must be one of 1 (Gaussian), 2 (Laplacian) or 3 (Rademacher).')
    if r == 1: # Run the rank-1 case.
        if len(sys.argv) < 6:
            errmsg = 'Missing u_scheme argument in r=1.'+'\n'+USAGE
            raise RuntimeError( errmsg )
        if len(sys.argv) > 6:
            warnmsg = 'WARNING: Ignoring trailing arguments.'
            print( warnmsg )
            print( USAGE )
        u_scheme = int(sys.argv[5])
        if u_scheme not in [0,1]:
            m='u_scheme must be either 0 (Bernoulli scheme) or 1 (Haar scheme).'
            raise RuntimeError( m )
        results = simulator_1(n, a, u_scheme, noise)
        results1 = results['results1']
        results2 = results['results2']
        df1 = pd.DataFrame.from_dict(results1)
        df2 = pd.DataFrame.from_dict(results2)
        print("Infty Estimation Error:")
        print(df1)
        print("Estimation Error of the Largest Entry:")
        print(df2)
    else: # r > 1; run the rank-r case.
        if len( sys.argv ) > 5:
            warnmsg = 'WARNING: Ignoring trailing arguments. u_scheme does not apply when r > 1.'
            print( warnmsg )
            print( USAGE )
        results = simulator_r(n, r, a, noise)
        results1 = results['results1']
        results2 = results['results2']
        results3 = results['results3']
        df1 = pd.DataFrame.from_dict(results1)
        df2 = pd.DataFrame.from_dict(results2)
        df3 = pd.DataFrame.from_dict(results3)
        print("Infty Estimation Error:")
        print(df1)
        print("Estimation Error of the Largest Entry:")
        print(df2)
        print("Two-to-Infty Estimation Error:")
        print(df3)
    
    
            
