# Latte Transformer
Set-up 

## pdm New Instalation
All scripts must be run from project root directory
2. Create the env or use the env from another project
```
    pdm venv create 3.10
    pdm use -f env-path
```

## Run with PDM
1. LRA
```
pdm run bash bin/run_lra.sh $PWD train_lra listops.yaml listops_lra
```
## Testing:
Being a research project, we do not focus on testing. However we introduce some integration testing for reusable components.
Example include the trainer:
```
pdm run python -m tests.trainer.test_jax_single_host
```

2. Copy Task
```
CUDA_VISIBLE_DEVICES="0" pdm run python3 -m latte_trans.experiments.copy --model "T_rope" --train_task "copy" --eval_task  "copy" --min_train_len 5 --max_train_len 20 --min_eval_len 20 --max_eval_len 20

pdm run bash bin/run_copy.sh $PWD train_copy copy.yaml test_copy

pdm run bash bin/run_copy.sh $PWD train_copy copy_test.yaml copy_test
```

3. Language Modelling
```
Train:
   pdm run bash bin/runsh.sh $PWD train_lmsh lm_owt.yaml test_model
   Evaluate:
   pdm run bash bin/runsh.sh $PWD eval_lmsh eval_owt.yaml test_model
```
4. Lava-Multimodal Learning
    1. Pretrain
    ```
    pdm run bash bin/runsh.sh $PWD train_mulmode mulmode_pretrain.yaml jax_lava
    ```
5. Pretraining on top of language models
```
pdm run bash bin/run_pret.sh $PWD train_lm_pret lm_pret.yaml test_gemma
pdm run bash bin/run_pret.sh $PWD eval_lm_pret lm_pret.yaml test_gemma
pdm run bash bin/run_pret.sh $PWD infer_lm infer.yaml test_gemma

bash bin/run_pret_pt.sh $PWD lm_pret_trans.yaml test_gemma_pt
```

6. Scroll Dataset
```
pdm run bash bin/runsh.sh $PWD train_scrolls scrolls.yaml test_gemma
```

7. NMT
```
pdm run bash bin/runsh.sh $PWD train_nmt nmt.yaml test_model
pdm run bash bin/runsh.sh $PWD eval_nmt nmt.yaml test_model
```
### Preproc Pile
```
CUDA_VISIBLE_DEVICES="2,3" pdm run python3 -m latte_trans.preproc.pile
```
 
## Runing Torch models
Installing both jax and torch with newest versions is a bit of pain. Better to install jax with compatible torch and the newest version of torch in a new environment.
Use torch pt_requirements.txt.

2. Language Modelling
```
bash bin/run_pt.sh $PWD lm_owt2.yaml test_model
```
3. Lava Model
```
bash bin/run_mulmode_pt.sh $PWD mullmode_pretrain.yaml test_lava_pt
```
4. Llama Model for pretraining:
 ```
    bash bin/run_pret_pt.sh $PWD lm_pret.yaml test_torch_llama
 ```
# Installing third party code
### Example setup:
Most of the repos ar not instalable via pip. To put them on the path add a simple setup.py file to each repo.
We do not want to install dependencies with poetry/other packae managers since we already use pdm. Better to manually add them with pdm
and simply add the repo to the path with pip.  
```
from setuptools import setup, find_packages
setup(
    name="foo",
    version="1.0",
    packages=find_packages(),
)
```
Then in the third party code simply run:
```
pip install -e .
```

### Fast tansformer
1. Export cuda for building fast-transformer
export PATH=/usr/local/cuda-12.3/bin${PATH:+:${PATH}}
export LD_LIBRARY_PATH=/usr/local/cuda-12.3/lib64\{LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}

git clone git@github.com:idiap/fast-transformers.git
cd fast-transformers
python setup.py build_ext --inplace
find fast_transformers/ | grep so$
pip install -e .

### Install RetNet
```
pip install torchscale
```
### Install Griffin
```
git clone git@github.com:google-deepmind/recurrentgemma.git ./lib/recurrentgemma
# integrate model code with my code
cp -r ./lib/recurrentgemma/recurrentgemma ./
```
### Install Mega
```
git clone git@github.com:facebookresearch/mega.git ./lib/mega
```

### Install RWKV
1. Download 
```
git clone git@github.com:BlinkDL/RWKV-LM.git ./lib/RWKV
pip install pytorch-lightning==1.9.5 deepspeed wandb ninja --upgrade
```
2. create setup.py
```
from setuptools import setup, find_packages
setup(
    name="RWKV",
    version="1.0",
    packages=find_packages(include=["RWKV-v5", "RWKV-v5.*"]),
    package_dir={"": "RWKV-v5"},
)
```
3. rename and install
Necessary so that we do not have to load from src.models import RWKV.
```
mv RWKV-v5/src mv RWKV-v5/RWKV5
# create a setup.py as per example above
pip install -e .
```

### Accelerate Config
/home/user/.cache/huggingface/accelerate/default_config.yaml 