#!/bin/bash
# Create a generic run script
ROOT_DIR=${1:-/home/user/latte_trans}
PDM_COMMAND=${2:-train_lm}
CONFIG_FILE=${3:-lm.yaml} # specify default
NAME=${4:-${CONFIG_FILE::-5}} # default is config file name apart from .yaml

# bash bash/run.sh /home/user/latte train_lm lm.yaml experimet_name
echo "Root Dir: ${ROOT_DIR} Name Experiment: ${NAME} Conf File: ${CONFIG_FILE}"
# nohup ,1,2,3,4,5,6,7
# CUDA_VISIBLE_DEVICES="3,4"
WANDB_MODE="online" XLA_PYTHON_CLIENT_MEM_FRACTION=100 CUDA_VISIBLE_DEVICES="7" pdm run $PDM_COMMAND \
    --base_dir $ROOT_DIR/data/ \
    --config_file $ROOT_DIR/latte_trans/experiments/config/${CONFIG_FILE}\
    --name $NAME \
>$ROOT_DIR/'data/logs_latte/'$NAME'_'$BASHPID'.log' 2>&1 &