#!/bin/bash
# Create a generic run script
ROOT_DIR=${1:-/home/user/latte_trans}
CONFIG_FILE=${2:-lm.yaml} # specify default
NAME=${3:-${CONFIG_FILE::-5}} # default is config file name apart from .yaml
# bash bash/run.sh /home/user/latte train_lm lm.yaml experimet_name
# export PYTHONPATH=$PYTHONPATH:/home/user/latte_trans/latte_trans
export PYTHONPATH=$PYTHONPATH:/home/user/latte_trans/lib/fast_transformers
export PATH=/usr/local/cuda-12.3/bin${PATH:+:${PATH}}

echo "Root Dir: ${ROOT_DIR} Name Experiment: ${NAME} Conf File: ${CONFIG_FILE}"
# nohup 0,1,2,3,4,5,6,7   # 0,1,2,3,
WANDB_MODE="online" XLA_PYTHON_CLIENT_MEM_FRACTION="0.90" CUDA_VISIBLE_DEVICES="4,5,6,7" accelerate launch  --multi_gpu \
    --num_processes=4 --main_process_port=2951 latte_trans/experiments/lm_pret_pt.py \
    --base_dir /data_user/data/ \
    --config_file $ROOT_DIR/latte_trans/experiments/config/${CONFIG_FILE}\
    --name $NAME \
    --evaluate \
#>$ROOT_DIR/'data/logs_match/'$NAME'_'$BASHPID'.log' 2>&1 &
# /mnt/data/ /data_user/data/ \
# $ROOT_DIR/data/ \
# --multi_gpu
# --mixed_precision=bf16
# --config_file /home/user/.cache/huggingface/accelerate/dfsp_default_config.yaml \
