#!/bin/bash
# Create a generic run script
ROOT_DIR=${1:-/home/user/latte_trans}
PDM_COMMAND=${2:-train_lm}
CONFIG_FILE=${3:-lm.yaml} # specify default
NAME=${4:-${CONFIG_FILE::-5}} # default is config file name apart from .yaml

# bash bash/run.sh /home/user/latte train_lm lm.yaml experimet_name
echo "Root Dir: ${ROOT_DIR} Name Experiment: ${NAME} Conf File: ${CONFIG_FILE}"
# nohup # 0,1,2,3,4,5,6,7  -  0,1,2,3  4,5,6,7 nohup - 0,1,2,3,s
JAX_TRACEBACK_FILTERING=off WANDB_MODE="online" XLA_PYTHON_CLIENT_MEM_FRACTION="0.97" CUDA_VISIBLE_DEVICES="4,5,6,7" pdm run $PDM_COMMAND \
    --base_dir /data_user/data/ \
    --config_file $ROOT_DIR/latte_trans/experiments/config/${CONFIG_FILE}\
    --name $NAME \
#>$ROOT_DIR/'data/logs_labl/'$NAME'_'$BASHPID'.log'  2>&1 &
# /data_user/data/ 
# /mnt/data 
#  /home/user/Documents/latte_trans/data
# logs_match
# logs_latte_4_test


# pdm run bash bin/runsh.sh $PWD train_lmsh lm_bookcorp.yaml bookcorp_seqlen_mach
# pdm run bash bin/runsh.sh $PWD eval_train lm_bookcorp.yaml test_bookcorp_seqlen_mach