#!/bin/bash
# Create a generic run script
ROOT_DIR=${1:-/home/user/latte_trans}
CONFIG_FILE=${2:-lm.yaml} # specify default
NAME=${3:-${CONFIG_FILE::-5}} # default is config file name apart from .yaml
# bash bash/run.sh /home/user/latte train_lm lm.yaml experimet_name
# export PYTHONPATH=$PYTHONPATH:/home/user/latte_trans/latte_trans
export PYTHONPATH=$PYTHONPATH:/home/user/latte_trans/lib/fast_transformers
# export PATH=/usr/local/cuda-12.3/bin${PATH:+:${PATH}}

# export NCCL_DEBUG=INFO
# export NCCL_DEBUG_SUBSYS=ALL
# export TORCH_DISTRIBUTED_DEBUG=INFO

echo "Root Dir: ${ROOT_DIR} Name Experiment: ${NAME} Conf File: ${CONFIG_FILE}"
# nohup 0,1,2,3,4,5,6,7   # 0,1,2,3,
WANDB_MODE="online" XLA_PYTHON_CLIENT_MEM_FRACTION="0.90" CUDA_VISIBLE_DEVICES="0,1,2,3" nohup accelerate launch  --multi_gpu --main_process_port=2951 latte_trans/experiments/lm_pt.py \
    --base_dir /data_user/data/ \
    --config_file $ROOT_DIR/latte_trans/experiments/config/${CONFIG_FILE}\
    --name $NAME \
>$ROOT_DIR/'data/logs_pret/'$NAME'_'$BASHPID'.log' 2>&1 &
# /mnt/data/ /data_user/data/ \
# $ROOT_DIR/data/ \
# --multi_gpu
# --mixed_precision=bf16