import os
import random
import sys

# comment this out if you are using the pip package
sys.path.append('../')

import torch
import matplotlib.pyplot as plt
from utils import FGVC_AIRCRAFT_CLASSES

# set root to ImageNet dataset
IMAGENET_ROOT = None

# path where to store an encoder, which we will load in with the learned tokens
encoder_root = "./encoder_root_pets"

# a subset of ImageNet classes
class_names = FGVC_AIRCRAFT_CLASSES
tokens = [f"<{class_names[i]}-{i}>" for i in range(len(class_names))]


code = '1000'
data_dir = 'data/gen{}'.format(code)
os.makedirs(data_dir, exist_ok=True)
from diffusers import StableDiffusionPipeline
from dataset_interface.templates import imagenet_templates_small
pipe = StableDiffusionPipeline.from_pretrained("runwayml/stable-diffusion-v1-5", torch_dtype=torch.float16)
pipe.to('cuda')
classes = range(100)
for i in classes:
    print('Generating image for {}-th class: {}'.format(i+1, class_names[i]))
    os.makedirs('data/gen{}/'.format(code)+class_names[i].replace('/', ''), exist_ok=True)
    img_idx = 0
    while img_idx < 1000:
        prompt = random.choice(imagenet_templates_small).format(class_names[i] + 'airplane')
        output = pipe(prompt, num_inference_steps=50, num_images_per_prompt=8,  guidance_scale=3.5)
        images = output.images
        nsfw = output.nsfw_content_detected
        for j in range(8):
            if nsfw[j] is False:
                images[j].save('data/gen{}/{}/sample{}.png'.format(code, class_names[i].replace('/', ''), img_idx+501))
                img_idx += 1
