import os
import random
import sys

# comment this out if you are using the pip package
sys.path.append('../')

import torch
import matplotlib.pyplot as plt
from utils import CLASS_DOGS, CLASS_FOR_Prompt

data_dir = 'data/gen1000'
os.makedirs(data_dir, exist_ok=True)
from diffusers import StableDiffusionPipeline
from dataset_interface.templates import imagenet_templates_small
pipe = StableDiffusionPipeline.from_pretrained("runwayml/stable-diffusion-v1-5", torch_dtype=torch.float16)
pipe.to('cuda')
classes = range(29, 30)
for i in classes:
    print('Generating image for {}-th class: {}'.format(i+1, CLASS_DOGS[i]))
    os.makedirs('data/gen1000/'+CLASS_DOGS[i], exist_ok=True)
    img_idx = 0
    while img_idx < 1000:
        prompt = random.choice(imagenet_templates_small).format(CLASS_FOR_Prompt[i])
        output = pipe(prompt, num_inference_steps=50, num_images_per_prompt=8,  guidance_scale=3.5)
        images = output.images
        nsfw = output.nsfw_content_detected
        for j in range(8):
            if nsfw[j] is False:
                images[j].save('data/gen1000/{}/sample{}.png'.format(CLASS_DOGS[i], img_idx+1))
                img_idx += 1
