import os
import random
import sys

# comment this out if you are using the pip package
sys.path.append('../')

import torch
import matplotlib.pyplot as plt
from dataset_interface import run_textual_inversion
from dataset_interface import generate
import dataset_interface.imagenet_utils as in_utils
import dataset_interface.inference_utils as infer_utils
from utils import DTD_CLASS_NAMES

# set root to ImageNet dataset
IMAGENET_ROOT = None

# path where to store an encoder, which we will load in with the learned tokens
encoder_root = "./encoder_root_dtd"

# a subset of ImageNet classes
classes = range(47)
class_names = DTD_CLASS_NAMES
tokens = [f"<{class_names[i]}-{i}>" for i in range(len(class_names))]

data_dir = 'data/gen1000'
os.mkdir(data_dir)
from diffusers import StableDiffusionPipeline
from dataset_interface.templates import imagenet_templates_small
pipe = StableDiffusionPipeline.from_pretrained("runwayml/stable-diffusion-v1-5", torch_dtype=torch.float16)
pipe.to('cuda')
for i in range(47):
    print('Generating image for {}-th class: {}'.format(i+1, class_names[i]))
    os.mkdir('data/gen1000/'+class_names[i])
    img_idx = 0
    while img_idx < 1000:
        prompt = random.choice(imagenet_templates_small).format(class_names[i]+' texture')
        output = pipe(prompt, num_inference_steps=50, num_images_per_prompt=8,  guidance_scale=3.5)
        images = output.images
        nsfw = output.nsfw_content_detected
        for j in range(8):
            if nsfw[j] is False:
                images[j].save('data/gen1000/{}/sample{}.png'.format(class_names[i], img_idx+1))
                img_idx += 1
