from imagecorruptions import corrupt, get_corruption_names
from PIL import Image
import numpy as np
import matplotlib.pyplot as plt
import time
from torchvision.datasets import Flowers102


dataset = Flowers102('data', transform=None, split='test')


for corruption in get_corruption_names('blur'):
    for i in range(len(dataset)):
        image_file = dataset._image_files[i]
        image_id = image_file[-4:-9]
        image = np.asarray(Image.open(image_file))
        corrupted = corrupt(image, corruption_name=corruption, severity=severity + 1)

    tic = time.time()
    for severity in range(5):
        corrupted = corrupt(image, corruption_name=corruption, severity=severity+1)
        plt.imshow(corrupted)
        plt.show()
    print(corruption, time.time() - tic)


