
import random
import sys
import os
# comment this out if you are using the pip package
sys.path.append('../')

import torch
import matplotlib.pyplot as plt
from utils import FLOWERS_LABEL_NAME

# set root to ImageNet dataset
IMAGENET_ROOT = None

# path where to store an encoder, which we will load in with the learned tokens
encoder_root = "./encoder_root_pets"

# a subset of ImageNet classes
classes = range(102)
class_names = FLOWERS_LABEL_NAME
tokens = [f"<{class_names[i]}-{i}>" for i in range(len(class_names))]


# Dataset 1/4: generate images based on the label. Presumably 200 images per class.
code = '2000'
data_dir = 'data/gen{}'.format(code)
from diffusers import StableDiffusionPipeline
from dataset_interface.templates import imagenet_templates_small
pipe = StableDiffusionPipeline.from_pretrained("runwayml/stable-diffusion-v1-5", torch_dtype=torch.float16)
pipe.to('cuda')

for i in range(76, 102):
    print('Generating image for {}-th class: {}'.format(i+1, class_names[i]))
    os.makedirs('data/gen{}/'.format(code)+class_names[i], exist_ok=True)
    img_idx = 0
    while img_idx < 2000:
        prompt = random.choice(imagenet_templates_small).format(class_names[i])
        output = pipe(prompt, num_inference_steps=50, num_images_per_prompt=8, guidance_scale=3.5)
        images = output.images
        nsfw = output.nsfw_content_detected
        for j in range(8):
            if nsfw[j] is False:
                images[j].save('data/gen{}/{}/sample{}.png'.format(code, class_names[i], img_idx+1))
                img_idx += 1