import os
import random
import sys

sys.path.append('../')

import torch
import matplotlib.pyplot as plt
from utils import CLASS_FOODS101

class_names = CLASS_FOODS101
tokens = [f"<{class_names[i]}-{i}>" for i in range(len(class_names))]


data_dir = 'data/gen2000'
os.makedirs(data_dir, exist_ok=True)
from diffusers import StableDiffusionPipeline
from dataset_interface.templates import imagenet_templates_small
pipe = StableDiffusionPipeline.from_pretrained("runwayml/stable-diffusion-v1-5", torch_dtype=torch.float16)
pipe.to('cuda')
for i in range(85, 100):
    print('Generating image for {}-th class: {}'.format(i+1, class_names[i]))
    if not os.path.exists('data/gen2000/'+str(i)):
        os.mkdir('data/gen2000/'+str(i))
    img_idx = 0
    while img_idx < 2000:
        prompt = random.choice(imagenet_templates_small).format(class_names[i].replace('_', ' '))
        output = pipe(prompt, num_inference_steps=50, num_images_per_prompt=8, guidance_scale=3.5)
        images = output.images
        nsfw = output.nsfw_content_detected
        for j in range(8):
            if nsfw[j] is False:
                images[j].save('data/gen2000/{}/sample{}.png'.format(i, img_idx+1))
                img_idx += 1

