# from openai https://github.com/openai/CLIP/blob/main/notebooks/Prompt_Engineering_for_ImageNet.ipynb
IMAGENET_COMMON_CLASS_NAMES = [
    "tench", "goldfish", "great white shark", "tiger shark", "hammerhead shark", "electric ray",
    "stingray", "rooster", "hen", "ostrich", "brambling", "goldfinch", "house finch", "junco",
    "indigo bunting", "American robin", "bulbul", "jay", "magpie", "chickadee", "American dipper",
    "kite (bird of prey)", "bald eagle", "vulture", "great grey owl", "fire salamander", "smooth newt",
    "newt", "spotted salamander", "axolotl", "American bullfrog", "tree frog", "tailed frog",
    "loggerhead sea turtle", "leatherback sea turtle", "mud turtle", "terrapin", "box turtle", "banded gecko",
    "green iguana", "Carolina anole", "desert grassland whiptail lizard", "agama", "frilled-necked lizard",
    "alligator lizard", "Gila monster", "European green lizard", "chameleon", "Komodo dragon", "Nile crocodile",
    "American alligator", "triceratops", "worm snake", "ring-necked snake", "eastern hog-nosed snake",
    "smooth green snake", "kingsnake", "garter snake", "water snake", "vine snake", "night snake",
    "boa constrictor", "African rock python", "Indian cobra", "green mamba", "sea snake", "Saharan horned viper",
    "eastern diamondback rattlesnake", "sidewinder rattlesnake", "trilobite", "harvestman", "scorpion",
    "yellow garden spider", "barn spider", "European garden spider", "southern black widow", "tarantula",
    "wolf spider", "tick", "centipede", "black grouse", "ptarmigan", "ruffed grouse", "prairie grouse",
    "peafowl", "quail", "partridge", "african grey parrot", "macaw", "sulphur-crested cockatoo", "lorikeet",
    "coucal", "bee eater", "hornbill", "hummingbird", "jacamar", "toucan", "duck", "red-breasted merganser",
    "goose", "black swan", "tusker", "echidna", "platypus", "wallaby", "koala", "wombat", "jellyfish",
    "sea anemone", "brain coral", "flatworm", "nematode", "conch", "snail", "slug", "sea slug", "chiton",
    "chambered nautilus", "Dungeness crab", "rock crab", "fiddler crab", "red king crab", "American lobster",
    "spiny lobster", "crayfish", "hermit crab", "isopod", "white stork", "black stork", "spoonbill",
    "flamingo", "little blue heron", "great egret", "bittern bird", "crane bird", "limpkin", "common gallinule",
    "American coot", "bustard", "ruddy turnstone", "dunlin", "common redshank", "dowitcher", "oystercatcher",
    "pelican", "king penguin", "albatross", "grey whale", "killer whale", "dugong", "sea lion", "Chihuahua",
    "Japanese Chin", "Maltese", "Pekingese", "Shih Tzu", "King Charles Spaniel", "Papillon", "toy terrier",
    "Rhodesian Ridgeback", "Afghan Hound", "Basset Hound", "Beagle", "Bloodhound", "Bluetick Coonhound",
    "Black and Tan Coonhound", "Treeing Walker Coonhound", "English foxhound", "Redbone Coonhound", "borzoi",
    "Irish Wolfhound", "Italian Greyhound", "Whippet", "Ibizan Hound", "Norwegian Elkhound", "Otterhound", "Saluki",
    "Scottish Deerhound", "Weimaraner", "Staffordshire Bull Terrier", "American Staffordshire Terrier",
    "Bedlington Terrier", "Border Terrier", "Kerry Blue Terrier", "Irish Terrier", "Norfolk Terrier",
    "Norwich Terrier", "Yorkshire Terrier", "Wire Fox Terrier", "Lakeland Terrier", "Sealyham Terrier",
    "Airedale Terrier", "Cairn Terrier", "Australian Terrier", "Dandie Dinmont Terrier", "Boston Terrier",
    "Miniature Schnauzer", "Giant Schnauzer", "Standard Schnauzer", "Scottish Terrier", "Tibetan Terrier",
    "Australian Silky Terrier", "Soft-coated Wheaten Terrier", "West Highland White Terrier", "Lhasa Apso",
    "Flat-Coated Retriever", "Curly-coated Retriever", "Golden Retriever", "Labrador Retriever",
    "Chesapeake Bay Retriever", "German Shorthaired Pointer", "Vizsla", "English Setter", "Irish Setter",
    "Gordon Setter", "Brittany dog", "Clumber Spaniel", "English Springer Spaniel", "Welsh Springer Spaniel",
    "Cocker Spaniel", "Sussex Spaniel", "Irish Water Spaniel", "Kuvasz", "Schipperke", "Groenendael dog",
    "Malinois", "Briard", "Australian Kelpie", "Komondor", "Old English Sheepdog", "Shetland Sheepdog", "collie",
    "Border Collie", "Bouvier des Flandres dog", "Rottweiler", "German Shepherd Dog", "Dobermann",
    "Miniature Pinscher", "Greater Swiss Mountain Dog", "Bernese Mountain Dog", "Appenzeller Sennenhund",
    "Entlebucher Sennenhund", "Boxer", "Bullmastiff", "Tibetan Mastiff", "French Bulldog", "Great Dane",
    "St. Bernard", "husky", "Alaskan Malamute", "Siberian Husky", "Dalmatian", "Affenpinscher",
    "Basenji", "pug", "Leonberger", "Newfoundland dog", "Great Pyrenees dog", "Samoyed", "Pomeranian",
    "Chow Chow", "Keeshond", "brussels griffon", "Pembroke Welsh Corgi", "Cardigan Welsh Corgi", "Toy Poodle",
    "Miniature Poodle", "Standard Poodle", "Mexican hairless dog (xoloitzcuintli)", "grey wolf",
    "Alaskan tundra wolf", "red wolf or maned wolf", "coyote", "dingo", "dhole", "African wild dog",
    "hyena", "red fox", "kit fox", "Arctic fox", "grey fox", "tabby cat", "tiger cat", "Persian cat",
    "Siamese cat", "Egyptian Mau", "cougar", "lynx", "leopard", "snow leopard", "jaguar", "lion", "tiger",
    "cheetah", "brown bear", "American black bear", "polar bear", "sloth bear", "mongoose", "meerkat",
    "tiger beetle", "ladybug", "ground beetle", "longhorn beetle", "leaf beetle", "dung beetle",
    "rhinoceros beetle", "weevil", "fly", "bee", "ant", "grasshopper", "cricket insect", "stick insect",
    "cockroach", "praying mantis", "cicada", "leafhopper", "lacewing", "dragonfly", "damselfly",
    "red admiral butterfly", "ringlet butterfly", "monarch butterfly", "small white butterfly",
    "sulphur butterfly", "gossamer-winged butterfly", "starfish", "sea urchin", "sea cucumber",
    "cottontail rabbit", "hare", "Angora rabbit", "hamster", "porcupine", "fox squirrel", "marmot", "beaver",
    "guinea pig", "common sorrel horse", "zebra", "pig", "wild boar", "warthog", "hippopotamus", "ox", "water buffalo",
    "bison", "ram (adult male sheep)", "bighorn sheep", "Alpine ibex", "hartebeest", "impala (antelope)", "gazelle",
    "arabian camel", "llama", "weasel", "mink", "European polecat", "black-footed ferret", "otter", "skunk",
    "badger", "armadillo", "three-toed sloth", "orangutan", "gorilla", "chimpanzee", "gibbon", "siamang",
    "guenon", "patas monkey", "baboon", "macaque", "langur", "black-and-white colobus", "proboscis monkey",
    "marmoset", "white-headed capuchin", "howler monkey", "titi monkey", "Geoffroy's spider monkey",
    "common squirrel monkey", "ring-tailed lemur", "indri", "Asian elephant", "African bush elephant",
    "red panda", "giant panda", "snoek fish", "eel", "silver salmon", "rock beauty fish", "clownfish",
    "sturgeon", "gar fish", "lionfish", "pufferfish", "abacus", "abaya", "academic gown", "accordion",
    "acoustic guitar", "aircraft carrier", "airliner", "airship", "altar", "ambulance", "amphibious vehicle",
    "analog clock", "apiary", "apron", "trash can", "assault rifle", "backpack", "bakery", "balance beam",
    "balloon", "ballpoint pen", "Band-Aid", "banjo", "baluster / handrail", "barbell", "barber chair",
    "barbershop", "barn", "barometer", "barrel", "wheelbarrow", "baseball", "basketball", "bassinet",
    "bassoon", "swimming cap", "bath towel", "bathtub", "station wagon", "lighthouse", "beaker",
    "military hat (bearskin or shako)", "beer bottle", "beer glass", "bell tower", "baby bib",
    "tandem bicycle", "bikini", "ring binder", "binoculars", "birdhouse", "boathouse", "bobsleigh",
    "bolo tie", "poke bonnet", "bookcase", "bookstore", "bottle cap", "hunting bow", "bow tie",
    "brass memorial plaque", "bra", "breakwater", "breastplate", "broom", "bucket", "buckle",
    "bulletproof vest", "high-speed train", "butcher shop", "taxicab", "cauldron", "candle", "cannon",
    "canoe", "can opener", "cardigan", "car mirror", "carousel", "tool kit", "cardboard box / carton",
    "car wheel", "automated teller machine", "cassette", "cassette player", "castle", "catamaran", "CD player",
    "cello", "mobile phone", "chain", "chain-link fence", "chain mail", "chainsaw", "storage chest", "chiffonier",
    "bell or wind chime", "china cabinet", "Christmas stocking", "church", "movie theater", "cleaver", "cliff dwelling",
    "cloak", "clogs", "cocktail shaker", "coffee mug", "coffeemaker", "spiral or coil", "combination lock",
    "computer keyboard", "candy store", "container ship", "convertible", "corkscrew", "cornet", "cowboy boot",
    "cowboy hat", "cradle", "construction crane", "crash helmet", "crate", "infant bed", "Crock Pot",
    "croquet ball", "crutch", "cuirass", "dam", "desk", "desktop computer", "rotary dial telephone", "diaper",
    "digital clock", "digital watch", "dining table", "dishcloth", "dishwasher", "disc brake", "dock",
    "dog sled", "dome", "doormat", "drilling rig", "drum", "drumstick", "dumbbell", "Dutch oven", "electric fan",
    "electric guitar", "electric locomotive", "entertainment center", "envelope", "espresso machine",
    "face powder", "feather boa", "filing cabinet", "fireboat", "fire truck", "fire screen", "flagpole",
    "flute", "folding chair", "football helmet", "forklift", "fountain", "fountain pen", "four-poster bed",
    "freight car", "French horn", "frying pan", "fur coat", "garbage truck", "gas mask or respirator",
    "gas pump", "goblet", "go-kart", "golf ball", "golf cart", "gondola", "gong", "gown", "grand piano",
    "greenhouse", "radiator grille", "grocery store", "guillotine", "hair clip", "hair spray", "half-track",
    "hammer", "hamper", "hair dryer", "hand-held computer", "handkerchief", "hard disk drive", "harmonica", "harp",
    "combine harvester", "hatchet", "holster", "home theater", "honeycomb", "hook", "hoop skirt",
    "gymnastic horizontal bar", "horse-drawn vehicle", "hourglass", "iPod", "clothes iron", "carved pumpkin",
    "jeans", "jeep", "T-shirt", "jigsaw puzzle", "rickshaw", "joystick", "kimono", "knee pad", "knot",
    "lab coat", "ladle", "lampshade", "laptop computer", "lawn mower", "lens cap", "letter opener", "library",
    "lifeboat", "lighter", "limousine", "ocean liner", "lipstick", "slip-on shoe", "lotion", "music speaker",
    "loupe magnifying glass", "sawmill", "magnetic compass", "messenger bag", "mailbox", "tights",
    "one-piece bathing suit", "manhole cover", "maraca", "marimba", "mask", "matchstick", "maypole", "maze",
    "measuring cup", "medicine cabinet", "megalith", "microphone", "microwave oven", "military uniform", "milk can",
    "minibus", "miniskirt", "minivan", "missile", "mitten", "mixing bowl", "mobile home", "ford model t", "modem",
    "monastery", "monitor", "moped", "mortar and pestle", "graduation cap", "mosque", "mosquito net", "vespa",
    "mountain bike", "tent", "computer mouse", "mousetrap", "moving van", "muzzle", "metal nail", "neck brace",
    "necklace", "baby pacifier", "notebook computer", "obelisk", "oboe", "ocarina", "odometer", "oil filter",
    "pipe organ", "oscilloscope", "overskirt", "bullock cart", "oxygen mask", "product packet / packaging",
    "paddle", "paddle wheel", "padlock", "paintbrush", "pajamas", "palace", "pan flute", "paper towel",
    "parachute", "parallel bars", "park bench", "parking meter", "railroad car", "patio", "payphone",
    "pedestal", "pencil case", "pencil sharpener", "perfume", "Petri dish", "photocopier", "plectrum",
    "Pickelhaube", "picket fence", "pickup truck", "pier", "piggy bank", "pill bottle", "pillow",
    "ping-pong ball", "pinwheel", "pirate ship", "drink pitcher", "block plane", "planetarium", "plastic bag",
    "plate rack", "farm plow", "plunger", "Polaroid camera", "pole", "police van", "poncho", "pool table",
    "soda bottle", "plant pot", "potter's wheel", "power drill", "prayer rug", "printer", "prison", "missile",
    "projector", "hockey puck", "punching bag", "purse", "quill", "quilt", "race car", "racket", "radiator",
    "radio", "radio telescope", "rain barrel", "recreational vehicle", "fishing casting reel", "reflex camera",
    "refrigerator", "remote control", "restaurant", "revolver", "rifle", "rocking chair", "rotisserie", "eraser",
    "rugby ball", "ruler measuring stick", "sneaker", "safe", "safety pin", "salt shaker", "sandal", "sarong",
    "saxophone", "scabbard", "weighing scale", "school bus", "schooner", "scoreboard", "CRT monitor", "screw",
    "screwdriver", "seat belt", "sewing machine", "shield", "shoe store", "shoji screen / room divider",
    "shopping basket", "shopping cart", "shovel", "shower cap", "shower curtain", "ski", "balaclava ski mask",
    "sleeping bag", "slide rule", "sliding door", "slot machine", "snorkel", "snowmobile", "snowplow",
    "soap dispenser", "soccer ball", "sock", "solar thermal collector", "sombrero", "soup bowl", "keyboard space bar",
    "space heater", "space shuttle", "spatula", "motorboat", "spider web", "spindle", "sports car", "spotlight", "stage",
    "steam locomotive", "through arch bridge", "steel drum", "stethoscope", "scarf", "stone wall", "stopwatch",
    "stove", "strainer", "tram", "stretcher", "couch", "stupa", "submarine", "suit", "sundial", "sunglasses",
    "sunglasses", "sunscreen", "suspension bridge", "mop", "sweatshirt", "swim trunks / shorts", "swing",
    "electrical switch", "syringe", "table lamp", "tank", "tape player", "teapot", "teddy bear", "television",
    "tennis ball", "thatched roof", "front curtain", "thimble", "threshing machine", "throne", "tile roof", "toaster",
    "tobacco shop", "toilet seat", "torch", "totem pole", "tow truck", "toy store", "tractor", "semi-trailer truck",
    "tray", "trench coat", "tricycle", "trimaran", "tripod", "triumphal arch", "trolleybus", "trombone", "hot tub",
    "turnstile", "typewriter keyboard", "umbrella", "unicycle", "upright piano", "vacuum cleaner", "vase",
    "vaulted or arched ceiling", "velvet fabric", "vending machine", "vestment", "viaduct", "violin", "volleyball",
    "waffle iron", "wall clock", "wallet", "wardrobe", "military aircraft", "sink", "washing machine", "water bottle",
    "water jug", "water tower", "whiskey jug", "whistle", "hair wig", "window screen", "window shade", "Windsor tie",
    "wine bottle", "airplane wing", "wok", "wooden spoon", "wool", "split-rail fence", "shipwreck", "sailboat", "yurt",
    "website", "comic book", "crossword", "traffic or street sign", "traffic light", "dust jacket", "menu", "plate",
    "guacamole", "consomme", "hot pot", "trifle", "ice cream", "popsicle", "baguette", "bagel", "pretzel", "cheeseburger",
    "hot dog", "mashed potatoes", "cabbage", "broccoli", "cauliflower", "zucchini", "spaghetti squash", "acorn squash",
    "butternut squash", "cucumber", "artichoke", "bell pepper", "cardoon", "mushroom", "Granny Smith apple",
    "strawberry", "orange", "lemon", "fig", "pineapple", "banana", "jackfruit", "cherimoya (custard apple)",
    "pomegranate", "hay", "carbonara", "chocolate syrup", "dough", "meatloaf", "pizza", "pot pie", "burrito",
    "red wine", "espresso", "tea cup", "eggnog", "mountain", "bubble", "cliff", "coral reef", "geyser",
    "lakeshore", "promontory", "sandbar", "beach", "valley", "volcano", "baseball player", "bridegroom",
    "scuba diver", "rapeseed", "daisy", "yellow lady's slipper", "corn", "acorn", "rose hip",
    "horse chestnut seed", "coral fungus", "agaric", "gyromitra", "stinkhorn mushroom", "earth star fungus",
    "hen of the woods mushroom", "bolete", "corn cob", "toilet paper"]

IMAGENET_IDX_TO_SYNSET = {
  "0": {"id": "n01440764", "label": "tench, Tinca tinca"},
  "1": {"id": "n01443537", "label": "goldfish, Carassius auratus"},
  "2": {"id": "n01484850", "label": "great white shark, white shark, man-eater, man-eating shark, Carcharodon carcharias"},
  "3": {"id": "n01491361", "label": "tiger shark, Galeocerdo cuvieri"},
  "4": {"id": "n01494475", "label": "hammerhead, hammerhead shark"},
  "5": {"id": "n01496331", "label": "electric ray, crampfish, numbfish, torpedo"},
  "6": {"id": "n01498041", "label": "stingray"},
  "7": {"id": "n01514668", "label": "cock"},
  "8": {"id": "n01514859", "label": "hen"},
  "9": {"id": "n01518878", "label": "ostrich, Struthio camelus"},
  "10": {"id": "n01530575", "label": "brambling, Fringilla montifringilla"},
  "11": {"id": "n01531178", "label": "goldfinch, Carduelis carduelis"},
  "12": {"id": "n01532829", "label": "house finch, linnet, Carpodacus mexicanus"},
  "13": {"id": "n01534433", "label": "junco, snowbird"},
  "14": {"id": "n01537544", "label": "indigo bunting, indigo finch, indigo bird, Passerina cyanea"},
  "15": {"id": "n01558993", "label": "robin, American robin, Turdus migratorius"},
  "16": {"id": "n01560419", "label": "bulbul"},
  "17": {"id": "n01580077", "label": "jay"},
  "18": {"id": "n01582220", "label": "magpie"},
  "19": {"id": "n01592084", "label": "chickadee"},
  "20": {"id": "n01601694", "label": "water ouzel, dipper"},
  "21": {"id": "n01608432", "label": "kite"},
  "22": {"id": "n01614925", "label": "bald eagle, American eagle, Haliaeetus leucocephalus"},
  "23": {"id": "n01616318", "label": "vulture"},
  "24": {"id": "n01622779", "label": "great grey owl, great gray owl, Strix nebulosa"},
  "25": {"id": "n01629819", "label": "European fire salamander, Salamandra salamandra"},
  "26": {"id": "n01630670", "label": "common newt, Triturus vulgaris"},
  "27": {"id": "n01631663", "label": "eft"},
  "28": {"id": "n01632458", "label": "spotted salamander, Ambystoma maculatum"},
  "29": {"id": "n01632777", "label": "axolotl, mud puppy, Ambystoma mexicanum"},
  "30": {"id": "n01641577", "label": "bullfrog, Rana catesbeiana"},
  "31": {"id": "n01644373", "label": "tree frog, tree-frog"},
  "32": {"id": "n01644900", "label": "tailed frog, bell toad, ribbed toad, tailed toad, Ascaphus trui"},
  "33": {"id": "n01664065", "label": "loggerhead, loggerhead turtle, Caretta caretta"},
  "34": {"id": "n01665541", "label": "leatherback turtle, leatherback, leathery turtle, Dermochelys coriacea"},
  "35": {"id": "n01667114", "label": "mud turtle"},
  "36": {"id": "n01667778", "label": "terrapin"},
  "37": {"id": "n01669191", "label": "box turtle, box tortoise"},
  "38": {"id": "n01675722", "label": "banded gecko"},
  "39": {"id": "n01677366", "label": "common iguana, iguana, Iguana iguana"},
  "40": {"id": "n01682714", "label": "American chameleon, anole, Anolis carolinensis"},
  "41": {"id": "n01685808", "label": "whiptail, whiptail lizard"},
  "42": {"id": "n01687978", "label": "agama"},
  "43": {"id": "n01688243", "label": "frilled lizard, Chlamydosaurus kingi"},
  "44": {"id": "n01689811", "label": "alligator lizard"},
  "45": {"id": "n01692333", "label": "Gila monster, Heloderma suspectum"},
  "46": {"id": "n01693334", "label": "green lizard, Lacerta viridis"},
  "47": {"id": "n01694178", "label": "African chameleon, Chamaeleo chamaeleon"},
  "48": {"id": "n01695060", "label": "Komodo dragon, Komodo lizard, dragon lizard, giant lizard, Varanus komodoensis"},
  "49": {"id": "n01697457", "label": "African crocodile, Nile crocodile, Crocodylus niloticus"},
  "50": {"id": "n01698640", "label": "American alligator, Alligator mississipiensis"},
  "51": {"id": "n01704323", "label": "triceratops"},
  "52": {"id": "n01728572", "label": "thunder snake, worm snake, Carphophis amoenus"},
  "53": {"id": "n01728920", "label": "ringneck snake, ring-necked snake, ring snake"},
  "54": {"id": "n01729322", "label": "hognose snake, puff adder, sand viper"},
  "55": {"id": "n01729977", "label": "green snake, grass snake"},
  "56": {"id": "n01734418", "label": "king snake, kingsnake"},
  "57": {"id": "n01735189", "label": "garter snake, grass snake"},
  "58": {"id": "n01737021", "label": "water snake"},
  "59": {"id": "n01739381", "label": "vine snake"},
  "60": {"id": "n01740131", "label": "night snake, Hypsiglena torquata"},
  "61": {"id": "n01742172", "label": "boa constrictor, Constrictor constrictor"},
  "62": {"id": "n01744401", "label": "rock python, rock snake, Python sebae"},
  "63": {"id": "n01748264", "label": "Indian cobra, Naja naja"},
  "64": {"id": "n01749939", "label": "green mamba"},
  "65": {"id": "n01751748", "label": "sea snake"},
  "66": {"id": "n01753488", "label": "horned viper, cerastes, sand viper, horned asp, Cerastes cornutus"},
  "67": {"id": "n01755581", "label": "diamondback, diamondback rattlesnake, Crotalus adamanteus"},
  "68": {"id": "n01756291", "label": "sidewinder, horned rattlesnake, Crotalus cerastes"},
  "69": {"id": "n01768244", "label": "trilobite"},
  "70": {"id": "n01770081", "label": "harvestman, daddy longlegs, Phalangium opilio"},
  "71": {"id": "n01770393", "label": "scorpion"},
  "72": {"id": "n01773157", "label": "black and gold garden spider, Argiope aurantia"},
  "73": {"id": "n01773549", "label": "barn spider, Araneus cavaticus"},
  "74": {"id": "n01773797", "label": "garden spider, Aranea diademata"},
  "75": {"id": "n01774384", "label": "black widow, Latrodectus mactans"},
  "76": {"id": "n01774750", "label": "tarantula"},
  "77": {"id": "n01775062", "label": "wolf spider, hunting spider"},
  "78": {"id": "n01776313", "label": "tick"},
  "79": {"id": "n01784675", "label": "centipede"},
  "80": {"id": "n01795545", "label": "black grouse"},
  "81": {"id": "n01796340", "label": "ptarmigan"},
  "82": {"id": "n01797886", "label": "ruffed grouse, partridge, Bonasa umbellus"},
  "83": {"id": "n01798484", "label": "prairie chicken, prairie grouse, prairie fowl"},
  "84": {"id": "n01806143", "label": "peacock"},
  "85": {"id": "n01806567", "label": "quail"},
  "86": {"id": "n01807496", "label": "partridge"},
  "87": {"id": "n01817953", "label": "African grey, African gray, Psittacus erithacus"},
  "88": {"id": "n01818515", "label": "macaw"},
  "89": {"id": "n01819313", "label": "sulphur-crested cockatoo, Kakatoe galerita, Cacatua galerita"},
  "90": {"id": "n01820546", "label": "lorikeet"},
  "91": {"id": "n01824575", "label": "coucal"},
  "92": {"id": "n01828970", "label": "bee eater"},
  "93": {"id": "n01829413", "label": "hornbill"},
  "94": {"id": "n01833805", "label": "hummingbird"},
  "95": {"id": "n01843065", "label": "jacamar"},
  "96": {"id": "n01843383", "label": "toucan"},
  "97": {"id": "n01847000", "label": "drake"},
  "98": {"id": "n01855032", "label": "red-breasted merganser, Mergus serrator"},
  "99": {"id": "n01855672", "label": "goose"},
  "100": {"id": "n01860187", "label": "black swan, Cygnus atratus"},
  "101": {"id": "n01871265", "label": "tusker"},
  "102": {"id": "n01872401", "label": "echidna, spiny anteater, anteater"},
  "103": {
    "id": "n01873310",
    "label": "platypus, duckbill, duckbilled platypus, duck-billed plapus, Ornithorhynchu anatinus"},
  "104": {"id": "n01877812", "label": "wallaby, brush kangaroo"},
  "105": {"id": "n01882714", "label": "koala, koala bear, kangaroo bear, native bear, Phascolarctos cinereus"},
  "106": {"id": "n01883070", "label": "wombat"},
  "107": {"id": "n01910747", "label": "jellyfish"},
  "108": {"id": "n01914609", "label": "sea anemone, anemone"},
  "109": {"id": "n01917289", "label": "brain coral"},
  "110": {"id": "n01924916", "label": "flatworm, platyhelminth"},
  "111": {"id": "n01930112", "label": "nematode, nematode worm, roundworm"},
  "112": {"id": "n01943899", "label": "conch"},
  "113": {"id": "n01944390", "label": "snail"},
  "114": {"id": "n01945685", "label": "slug"},
  "115": {"id": "n01950731", "label": "sea slug, nudibranch"},
  "116": {"id": "n01955084", "label": "chiton, coat-of-mail shell, sea cradle, polyplacophore"},
  "117": {"id": "n01968897", "label": "chambered nautilus, pearly nautilus, nautilus"},
  "118": {"id": "n01978287", "label": "Dungeness crab, Cancer magister"},
  "119": {"id": "n01978455", "label": "rock crab, Cancer irroratus"},
  "120": {"id": "n01980166", "label": "fiddler crab"},
  "121": {"id": "n01981276", "label": "king crab, Alaska crab, Alaskan king crab, Alaska king crab, Paralithodes camtschatica"},
  "122": {"id": "n01983481", "label": "American lobster, Northern lobster, Maine lobster, Homarus americanus"},
  "123": {"id": "n01984695", "label": "spiny lobster, langouste, rock lobster, crawfish, crayfish, sea crawfish"},
  "124": {"id": "n01985128", "label": "crayfish, crawfish, crawdad, crawdaddy"},
  "125": {"id": "n01986214", "label": "hermit crab"},
  "126": {"id": "n01990800", "label": "isopod"},
  "127": {"id": "n02002556", "label": "white stork, Ciconia ciconia"},
  "128": {"id": "n02002724", "label": "black stork, Ciconia nigra"},
  "129": {"id": "n02006656", "label": "spoonbill"},
  "130": {"id": "n02007558", "label": "flamingo"},
  "131": {"id": "n02009229", "label": "little blue heron, Egretta caerulea"},
  "132": {"id": "n02009912", "label": "American egret, great white heron, Egretta albus"},
  "133": {"id": "n02011460", "label": "bittern"},
  "134": {"id": "n02012849", "label": "crane"},
  "135": {"id": "n02013706", "label": "limpkin, Aramus pictus"},
  "136": {"id": "n02017213", "label": "European gallinule, Porphyrio porphyrio"},
  "137": {"id": "n02018207", "label": "American coot, marsh hen, mud hen, water hen, Fulica americana"},
  "138": {"id": "n02018795", "label": "bustard"},
  "139": {"id": "n02025239", "label": "ruddy turnstone, Arenaria interpres"},
  "140": {"id": "n02027492", "label": "red-backed sandpiper, dunlin, Erolia alpina"},
  "141": {"id": "n02028035", "label": "redshank, Tringa totanus"},
  "142": {"id": "n02033041", "label": "dowitcher"},
  "143": {"id": "n02037110", "label": "oystercatcher, oyster catcher"},
  "144": {"id": "n02051845", "label": "pelican"},
  "145": {"id": "n02056570", "label": "king penguin, Aptenodytes patagonica"},
  "146": {"id": "n02058221", "label": "albatross, mollymawk"},
  "147": {"id": "n02066245", "label": "grey whale, gray whale, devilfish, Eschrichtius gibbosus, Eschrichtius robustus"},
  "148": {"id": "n02071294", "label": "killer whale, killer, orca, grampus, sea wolf, Orcinus orca"},
  "149": {"id": "n02074367", "label": "dugong, Dugong dugon"},
  "150": {"id": "n02077923", "label": "sea lion"},
  "151": {"id": "n02085620", "label": "Chihuahua"},
  "152": {"id": "n02085782", "label": "Japanese spaniel"},
  "153": {"id": "n02085936", "label": "Maltese dog, Maltese terrier, Maltese"},
  "154": {"id": "n02086079", "label": "Pekinese, Pekingese, Peke"},
  "155": {"id": "n02086240", "label": "Shih-Tzu"},
  "156": {"id": "n02086646", "label": "Blenheim spaniel"},
  "157": {"id": "n02086910", "label": "papillon"},
  "158": {"id": "n02087046", "label": "toy terrier"},
  "159": {"id": "n02087394", "label": "Rhodesian ridgeback"},
  "160": {"id": "n02088094", "label": "Afghan hound, Afghan"},
  "161": {"id": "n02088238", "label": "basset, basset hound"},
  "162": {"id": "n02088364", "label": "beagle"},
  "163": {"id": "n02088466", "label": "bloodhound, sleuthhound"},
  "164": {"id": "n02088632", "label": "bluetick"},
  "165": {"id": "n02089078", "label": "black-and-tan coonhound"},
  "166": {"id": "n02089867", "label": "Walker hound, Walker foxhound"},
  "167": {"id": "n02089973", "label": "English foxhound"},
  "168": {"id": "n02090379", "label": "redbone"},
  "169": {"id": "n02090622", "label": "borzoi, Russian wolfhound"},
  "170": {"id": "n02090721", "label": "Irish wolfhound"},
  "171": {"id": "n02091032", "label": "Italian greyhound"},
  "172": {"id": "n02091134", "label": "whippet"},
  "173": {"id": "n02091244", "label": "Ibizan hound, Ibizan Podenco"},
  "174": {"id": "n02091467", "label": "Norwegian elkhound, elkhound"},
  "175": {"id": "n02091635", "label": "otterhound, otter hound"},
  "176": {"id": "n02091831", "label": "Saluki, gazelle hound"},
  "177": {"id": "n02092002", "label": "Scottish deerhound, deerhound"},
  "178": {"id": "n02092339", "label": "Weimaraner"},
  "179": {"id": "n02093256", "label": "Staffordshire bullterrier, Staffordshire bull terrier"},
  "180": {"id": "n02093428", "label": "American Staffordshire terrier, Staffordshire terrier, Americanit bull terrier, pi bull terrier"},
  "181": {"id": "n02093647", "label": "Bedlington terrier"},
  "182": {"id": "n02093754", "label": "Border terrier"},
  "183": {"id": "n02093859", "label": "Kerry blue terrier"},
  "184": {"id": "n02093991", "label": "Irish terrier"},
  "185": {"id": "n02094114", "label": "Norfolk terrier"},
  "186": {"id": "n02094258", "label": "Norwich terrier"},
  "187": {"id": "n02094433", "label": "Yorkshire terrier"},
  "188": {"id": "n02095314", "label": "wire-haired fox terrier"},
  "189": {"id": "n02095570", "label": "Lakeland terrier"},
  "190": {"id": "n02095889", "label": "Sealyham terrier, Sealyham"},
  "191": {"id": "n02096051", "label": "Airedale, Airedale terrier"},
  "192": {"id": "n02096177", "label": "cairn, cairn terrier"},
  "193": {"id": "n02096294", "label": "Australian terrier"},
  "194": {"id": "n02096437", "label": "Dandie Dinmont, Dandie Dinmont terrier"},
  "195": {"id": "n02096585", "label": "Boston bull, Boston terrier"},
  "196": {"id": "n02097047", "label": "miniature schnauzer"},
  "197": {"id": "n02097130", "label": "giant schnauzer"},
  "198": {"id": "n02097209", "label": "standard schnauzer"},
  "199": {"id": "n02097298", "label": "Scotch terrier, Scottish terrier, Scottie"},
  "200": {"id": "n02097474", "label": "Tibetan terrier, chrysanthemum dog"},
  "201": {"id": "n02097658", "label": "silky terrier, Sydney silky"},
  "202": {"id": "n02098105", "label": "soft-coated wheaten terrier"},
  "203": {"id": "n02098286", "label": "West Highland white terrier"},
  "204": {"id": "n02098413", "label": "Lhasa, Lhasa apso"},
  "205": {"id": "n02099267", "label": "flat-coated retriever"},
  "206": {"id": "n02099429", "label": "curly-coated retriever"},
  "207": {"id": "n02099601", "label": "golden retriever"},
  "208": {"id": "n02099712", "label": "Labrador retriever"},
  "209": {"id": "n02099849", "label": "Chesapeake Bay retriever"},
  "210": {"id": "n02100236", "label": "German short-haired pointer"},
  "211": {"id": "n02100583", "label": "vizsla, Hungarian pointer"},
  "212": {"id": "n02100735", "label": "English setter"},
  "213": {"id": "n02100877", "label": "Irish setter, red setter"},
  "214": {"id": "n02101006", "label": "Gordon setter"},
  "215": {"id": "n02101388", "label": "Brittany spaniel"},
  "216": {"id": "n02101556", "label": "clumber, clumber spaniel"},
  "217": {"id": "n02102040", "label": "English springer, English springer spaniel"},
  "218": {"id": "n02102177", "label": "Welsh springer spaniel"},
  "219": {"id": "n02102318", "label": "cocker spaniel, English cocker spaniel, cocker"},
  "220": {"id": "n02102480", "label": "Sussex spaniel"},
  "221": {"id": "n02102973", "label": "Irish water spaniel"},
  "222": {"id": "n02104029", "label": "kuvasz"},
  "223": {"id": "n02104365", "label": "schipperke"},
  "224": {"id": "n02105056", "label": "groenendael"},
  "225": {"id": "n02105162", "label": "malinois"},
  "226": {"id": "n02105251", "label": "briard"},
  "227": {"id": "n02105412", "label": "kelpie"},
  "228": {"id": "n02105505", "label": "komondor"},
  "229": {"id": "n02105641", "label": "Old English sheepdog, bobtail"},
  "230": {"id": "n02105855", "label": "Shetland sheepdog, Shetland sheep dog, Shetland"},
  "231": {"id": "n02106030", "label": "collie"},
  "232": {"id": "n02106166", "label": "Border collie"},
  "233": {"id": "n02106382", "label": "Bouvier des Flandres, Bouviers des Flandres"},
  "234": {"id": "n02106550", "label": "Rottweiler"},
  "235": {"id": "n02106662", "label": "German shepherd, German shepherd dog, German police dog, alsatian"},
  "236": {"id": "n02107142", "label": "Doberman, Doberman pinscher"},
  "237": {"id": "n02107312", "label": "miniature pinscher"},
  "238": {"id": "n02107574", "label": "Greater Swiss Mountain dog"},
  "239": {"id": "n02107683", "label": "Bernese mountain dog"},
  "240": {"id": "n02107908", "label": "Appenzeller"},
  "241": {"id": "n02108000", "label": "EntleBucher"},
  "242": {"id": "n02108089", "label": "boxer"},
  "243": {"id": "n02108422", "label": "bull mastiff"},
  "244": {"id": "n02108551", "label": "Tibetan mastiff"},
  "245": {"id": "n02108915", "label": "French bulldog"},
  "246": {"id": "n02109047", "label": "Great Dane"},
  "247": {"id": "n02109525", "label": "Saint Bernard, St Bernard"},
  "248": {"id": "n02109961", "label": "Eskimo dog, husky"},
  "249": {"id": "n02110063", "label": "malamute, malemute, Alaskan malamute"},
  "250": {"id": "n02110185", "label": "Siberian husky"},
  "251": {"id": "n02110341", "label": "dalmatian, coach dog, carriage dog"},
  "252": {"id": "n02110627", "label": "affenpinscher, monkey pinscher, monkey dog"},
  "253": {"id": "n02110806", "label": "basenji"},
  "254": {"id": "n02110958", "label": "pug, pug-dog"},
  "255": {"id": "n02111129", "label": "Leonberg"},
  "256": {"id": "n02111277", "label": "Newfoundland, Newfoundland dog"},
  "257": {"id": "n02111500", "label": "Great Pyrenees"},
  "258": {"id": "n02111889", "label": "Samoyed, Samoyede"},
  "259": {"id": "n02112018", "label": "Pomeranian"},
  "260": {"id": "n02112137", "label": "chow, chow chow"},
  "261": {"id": "n02112350", "label": "keeshond"},
  "262": {"id": "n02112706", "label": "Brabancon griffon"},
  "263": {"id": "n02113023", "label": "Pembroke, Pembroke Welsh corgi"},
  "264": {"id": "n02113186", "label": "Cardigan, Cardigan Welsh corgi"},
  "265": {"id": "n02113624", "label": "toy poodle"},
  "266": {"id": "n02113712", "label": "miniature poodle"},
  "267": {"id": "n02113799", "label": "standard poodle"},
  "268": {"id": "n02113978", "label": "Mexican hairless"},
  "269": {"id": "n02114367", "label": "timber wolf, grey wolf, gray wolf, Canis lupus"},
  "270": {"id": "n02114548", "label": "white wolf, Arctic wolf, Canis lupus tundrarum"},
  "271": {"id": "n02114712", "label": "red wolf, maned wolf, Canis rufus, Canis niger"},
  "272": {"id": "n02114855", "label": "coyote, prairie wolf, brush wolf, Canis latrans"},
  "273": {"id": "n02115641", "label": "dingo, warrigal, warragal, Canis dingo"},
  "274": {"id": "n02115913", "label": "dhole, Cuon alpinus"},
  "275": {"id": "n02116738", "label": "African hunting dog, hyena dog, Cape hunting dog, Lycaon pictus"},
  "276": {"id": "n02117135", "label": "hyena, hyaena"},
  "277": {"id": "n02119022", "label": "red fox, Vulpes vulpes"},
  "278": {"id": "n02119789", "label": "kit fox, Vulpes macrotis"},
  "279": {"id": "n02120079", "label": "Arctic fox, white fox, Alopex lagopus"},
  "280": {"id": "n02120505", "label": "grey fox, gray fox, Urocyon cinereoargenteus"},
  "281": {"id": "n02123045", "label": "tabby, tabby cat"},
  "282": {"id": "n02123159", "label": "tiger cat"},
  "283": {"id": "n02123394", "label": "Persian cat"},
  "284": {"id": "n02123597", "label": "Siamese cat, Siamese"},
  "285": {"id": "n02124075", "label": "Egyptian cat"},
  "286": {"id": "n02125311", "label": "cougar, puma, catamount, mountain lion, painter, panther, Felis concolor"},
  "287": {"id": "n02127052", "label": "lynx, catamount"},
  "288": {"id": "n02128385", "label": "leopard, Panthera pardus"},
  "289": {"id": "n02128757", "label": "snow leopard, ounce, Panthera uncia"},
  "290": {"id": "n02128925", "label": "jaguar, panther, Panthera onca, Felis onca"},
  "291": {"id": "n02129165", "label": "lion, king of beasts, Panthera leo"},
  "292": {"id": "n02129604", "label": "tiger, Panthera tigris"},
  "293": {"id": "n02130308", "label": "cheetah, chetah, Acinonyx jubatus"},
  "294": {"id": "n02132136", "label": "brown bear, bruin, Ursus arctos"},
  "295": {"id": "n02133161", "label": "American black bear, black bear, Ursus americanus, Euarctos americanus"},
  "296": {"id": "n02134084", "label": "ice bear, polar bear, Ursus Maritimus, Thalarctos maritimus"},
  "297": {"id": "n02134418", "label": "sloth bear, Melursus ursinus, Ursus ursinus"},
  "298": {"id": "n02137549", "label": "mongoose"},
  "299": {"id": "n02138441", "label": "meerkat, mierkat"},
  "300": {"id": "n02165105", "label": "tiger beetle"},
  "301": {"id": "n02165456", "label": "ladybug, ladybeetle, lady beetle, ladybird, ladybird beetle"},
  "302": {"id": "n02167151", "label": "ground beetle, carabid beetle"},
  "303": {"id": "n02168699", "label": "long-horned beetle, longicorn, longicorn beetle"},
  "304": {"id": "n02169497", "label": "leaf beetle, chrysomelid"},
  "305": {"id": "n02172182", "label": "dung beetle"},
  "306": {"id": "n02174001", "label": "rhinoceros beetle"},
  "307": {"id": "n02177972", "label": "weevil"},
  "308": {"id": "n02190166", "label": "fly"},
  "309": {"id": "n02206856", "label": "bee"},
  "310": {"id": "n02219486", "label": "ant, emmet, pismire"},
  "311": {"id": "n02226429", "label": "grasshopper, hopper"},
  "312": {"id": "n02229544", "label": "cricket"},
  "313": {"id": "n02231487", "label": "walking stick, walkingstick, stick insect"},
  "314": {"id": "n02233338", "label": "cockroach, roach"},
  "315": {"id": "n02236044", "label": "mantis, mantid"},
  "316": {"id": "n02256656", "label": "cicada, cicala"},
  "317": {"id": "n02259212", "label": "leafhopper"},
  "318": {"id": "n02264363", "label": "lacewing, lacewing fly"},
  "319": {"id": "n02268443", "label": "dragonfly, darning needle, devil's darning needle, sewing needl snake feeder, snak doctor, mosquito hawk, skeeter hawk"},
  "320": {"id": "n02268853", "label": "damselfly"},
  "321": {"id": "n02276258", "label": "admiral"},
  "322": {"id": "n02277742", "label": "ringlet, ringlet butterfly"},
  "323": {"id": "n02279972", "label": "monarch, monarch butterfly, milkweed butterfly, Danaus plexippus"},
  "324": {"id": "n02280649", "label": "cabbage butterfly"},
  "325": {"id": "n02281406", "label": "sulphur butterfly, sulfur butterfly"},
  "326": {"id": "n02281787", "label": "lycaenid, lycaenid butterfly"},
  "327": {"id": "n02317335", "label": "starfish, sea star"},
  "328": {"id": "n02319095", "label": "sea urchin"},
  "329": {"id": "n02321529", "label": "sea cucumber, holothurian"},
  "330": {"id": "n02325366", "label": "wood rabbit, cottontail, cottontail rabbit"},
  "331": {"id": "n02326432", "label": "hare"},
  "332": {"id": "n02328150", "label": "Angora, Angora rabbit"},
  "333": {"id": "n02342885", "label": "hamster"},
  "334": {"id": "n02346627", "label": "porcupine, hedgehog"},
  "335": {"id": "n02356798", "label": "fox squirrel, eastern fox squirrel, Sciurus niger"},
  "336": {"id": "n02361337", "label": "marmot"},
  "337": {"id": "n02363005", "label": "beaver"},
  "338": {"id": "n02364673", "label": "guinea pig, Cavia cobaya"},
  "339": {"id": "n02389026", "label": "sorrel"},
  "340": {"id": "n02391049", "label": "zebra"},
  "341": {"id": "n02395406", "label": "hog, pig, grunter, squealer, Sus scrofa"},
  "342": {"id": "n02396427", "label": "wild boar, boar, Sus scrofa"},
  "343": {"id": "n02397096", "label": "warthog"},
  "344": {"id": "n02398521", "label": "hippopotamus, hippo, river horse, Hippopotamus amphibius"},
  "345": {"id": "n02403003", "label": "ox"},
  "346": {"id": "n02408429", "label": "water buffalo, water ox, Asiatic buffalo, Bubalus bubalis"},
  "347": {"id": "n02410509", "label": "bison"},
  "348": {"id": "n02412080", "label": "ram, tup"},
  "349": {"id": "n02415577", "label": "bighorn, bighorn sheep, cimarron, Rocky Mountain bighorn, RockMountain sheep, Ovi canadensis"},
  "350": {"id": "n02417914", "label": "ibex, Capra ibex"},
  "351": {"id": "n02422106", "label": "hartebeest"},
  "352": {"id": "n02422699", "label": "impala, Aepyceros melampus"},
  "353": {"id": "n02423022", "label": "gazelle"},
  "354": {"id": "n02437312", "label": "Arabian camel, dromedary, Camelus dromedarius"},
  "355": {"id": "n02437616", "label": "llama"},
  "356": {"id": "n02441942", "label": "weasel"},
  "357": {"id": "n02442845", "label": "mink"},
  "358": {"id": "n02443114", "label": "polecat, fitch, foulmart, foumart, Mustela putorius"},
  "359": {"id": "n02443484", "label": "black-footed ferret, ferret, Mustela nigripes"},
  "360": {"id": "n02444819", "label": "otter"},
  "361": {"id": "n02445715", "label": "skunk, polecat, wood pussy"},
  "362": {"id": "n02447366", "label": "badger"},
  "363": {"id": "n02454379", "label": "armadillo"},
  "364": {"id": "n02457408", "label": "three-toed sloth, ai, Bradypus tridactylus"},
  "365": {"id": "n02480495", "label": "orangutan, orang, orangutang, Pongo pygmaeus"},
  "366": {"id": "n02480855", "label": "gorilla, Gorilla gorilla"},
  "367": {"id": "n02481823", "label": "chimpanzee, chimp, Pan troglodytes"},
  "368": {"id": "n02483362", "label": "gibbon, Hylobates lar"},
  "369": {"id": "n02483708", "label": "siamang, Hylobates syndactylus, Symphalangus syndactylus"},
  "370": {"id": "n02484975", "label": "guenon, guenon monkey"},
  "371": {"id": "n02486261", "label": "patas, hussar monkey, Erythrocebus patas"},
  "372": {"id": "n02486410", "label": "baboon"},
  "373": {"id": "n02487347", "label": "macaque"},
  "374": {"id": "n02488291", "label": "langur"},
  "375": {"id": "n02488702", "label": "colobus, colobus monkey"},
  "376": {"id": "n02489166", "label": "proboscis monkey, Nasalis larvatus"},
  "377": {"id": "n02490219", "label": "marmoset"},
  "378": {"id": "n02492035", "label": "capuchin, ringtail, Cebus capucinus"},
  "379": {"id": "n02492660", "label": "howler monkey, howler"},
  "380": {"id": "n02493509", "label": "titi, titi monkey"},
  "381": {"id": "n02493793", "label": "spider monkey, Ateles geoffroyi"},
  "382": {"id": "n02494079", "label": "squirrel monkey, Saimiri sciureus"},
  "383": {"id": "n02497673", "label": "Madagascar cat, ring-tailed lemur, Lemur catta"},
  "384": {"id": "n02500267", "label": "indri, indris, Indri indri, Indri brevicaudatus"},
  "385": {"id": "n02504013", "label": "Indian elephant, Elephas maximus"},
  "386": {"id": "n02504458", "label": "African elephant, Loxodonta africana"},
  "387": {"id": "n02509815", "label": "lesser panda, red panda, panda, bear cat, cat bear, Ailurus fulgens"},
  "388": {"id": "n02510455", "label": "giant panda, panda, panda bear, coon bear, Ailuropoda melanoleuca"},
  "389": {"id": "n02514041", "label": "barracouta, snoek"},
  "390": {"id": "n02526121", "label": "eel"},
  "391": {"id": "n02536864", "label": "coho, cohoe, coho salmon, blue jack, silver salmon, Oncorhynchus kisutch"},
  "392": {"id": "n02606052", "label": "rock beauty, Holocanthus tricolor"},
  "393": {"id": "n02607072", "label": "anemone fish"},
  "394": {"id": "n02640242", "label": "sturgeon"},
  "395": {"id": "n02641379", "label": "gar, garfish, garpike, billfish, Lepisosteus osseus"},
  "396": {"id": "n02643566", "label": "lionfish"},
  "397": {"id": "n02655020", "label": "puffer, pufferfish, blowfish, globefish"},
  "398": {"id": "n02666196", "label": "abacus"},
  "399": {"id": "n02667093", "label": "abaya"},
  "400": {"id": "n02669723", "label": "academic gown, academic robe, judge's robe"},
  "401": {"id": "n02672831", "label": "accordion, piano accordion, squeeze box"},
  "402": {"id": "n02676566", "label": "acoustic guitar"},
  "403": {"id": "n02687172", "label": "aircraft carrier, carrier, flattop, attack aircraft carrier"},
  "404": {"id": "n02690373", "label": "airliner"},
  "405": {"id": "n02692877", "label": "airship, dirigible"},
  "406": {"id": "n02699494", "label": "altar"},
  "407": {"id": "n02701002", "label": "ambulance"},
  "408": {"id": "n02704792", "label": "amphibian, amphibious vehicle"},
  "409": {"id": "n02708093", "label": "analog clock"},
  "410": {"id": "n02727426", "label": "apiary, bee house"},
  "411": {"id": "n02730930", "label": "apron"},
  "412": {"id": "n02747177", "label": "ashcan, trash can, garbage can, wastebin, ash bin, ash-bin, hbin, dustbin, tras barrel, trash bin"},
  "413": {"id": "n02749479", "label": "assault rifle, assault gun"},
  "414": {"id": "n02769748", "label": "backpack, back pack, knapsack, packsack, rucksack, haversack"},
  "415": {"id": "n02776631", "label": "bakery, bakeshop, bakehouse"},
  "416": {"id": "n02777292", "label": "balance beam, beam"},
  "417": {"id": "n02782093", "label": "balloon"},
  "418": {"id": "n02783161", "label": "ballpoint, ballpoint pen, ballpen, Biro"},
  "419": {"id": "n02786058", "label": "Band Aid"},
  "420": {"id": "n02787622", "label": "banjo"},
  "421": {"id": "n02788148", "label": "bannister, banister, balustrade, balusters, handrail"},
  "422": {"id": "n02790996", "label": "barbell"},
  "423": {"id": "n02791124", "label": "barber chair"},
  "424": {"id": "n02791270", "label": "barbershop"},
  "425": {"id": "n02793495", "label": "barn"},
  "426": {"id": "n02794156", "label": "barometer"},
  "427": {"id": "n02795169", "label": "barrel, cask"},
  "428": {"id": "n02797295", "label": "barrow, garden cart, lawn cart, wheelbarrow"},
  "429": {"id": "n02799071", "label": "baseball"},
  "430": {"id": "n02802426", "label": "basketball"},
  "431": {"id": "n02804414", "label": "bassinet"},
  "432": {"id": "n02804610", "label": "bassoon"},
  "433": {"id": "n02807133", "label": "bathing cap, swimming cap"},
  "434": {"id": "n02808304", "label": "bath towel"},
  "435": {"id": "n02808440", "label": "bathtub, bathing tub, bath, tub"},
  "436": {"id": "n02814533", "label": "beach wagon, station wagon, wagon, estate car, beach waggon, station waggon, waggon"},
  "437": {"id": "n02814860", "label": "beacon, lighthouse, beacon light, pharos"},
  "438": {"id": "n02815834", "label": "beaker"},
  "439": {"id": "n02817516", "label": "bearskin, busby, shako"},
  "440": {"id": "n02823428", "label": "beer bottle"},
  "441": {"id": "n02823750", "label": "beer glass"},
  "442": {"id": "n02825657", "label": "bell cote, bell cot"},
  "443": {"id": "n02834397", "label": "bib"},
  "444": {"id": "n02835271", "label": "bicycle-built-for-two, tandem bicycle, tandem"},
  "445": {"id": "n02837789", "label": "bikini, two-piece"},
  "446": {"id": "n02840245", "label": "binder, ring-binder"},
  "447": {"id": "n02841315", "label": "binoculars, field glasses, opera glasses"},
  "448": {"id": "n02843684", "label": "birdhouse"},
  "449": {"id": "n02859443", "label": "boathouse"},
  "450": {"id": "n02860847", "label": "bobsled, bobsleigh, bob"},
  "451": {"id": "n02865351", "label": "bolo tie, bolo, bola tie, bola"},
  "452": {"id": "n02869837", "label": "bonnet, poke bonnet"},
  "453": {"id": "n02870880", "label": "bookcase"},
  "454": {"id": "n02871525", "label": "bookshop, bookstore, bookstall"},
  "455": {"id": "n02877765", "label": "bottlecap"},
  "456": {"id": "n02879718", "label": "bow"},
  "457": {"id": "n02883205", "label": "bow tie, bow-tie, bowtie"},
  "458": {"id": "n02892201", "label": "brass, memorial tablet, plaque"},
  "459": {"id": "n02892767", "label": "brassiere, bra, bandeau"},
  "460": {"id": "n02894605", "label": "breakwater, groin, groyne, mole, bulwark, seawall, jetty"},
  "461": {"id": "n02895154", "label": "breastplate, aegis, egis"},
  "462": {"id": "n02906734", "label": "broom"},
  "463": {"id": "n02909870", "label": "bucket, pail"},
  "464": {"id": "n02910353", "label": "buckle"},
  "465": {"id": "n02916936", "label": "bulletproof vest"},
  "466": {"id": "n02917067", "label": "bullet train, bullet"},
  "467": {"id": "n02927161", "label": "butcher shop, meat market"},
  "468": {"id": "n02930766", "label": "cab, hack, taxi, taxicab"},
  "469": {"id": "n02939185", "label": "caldron, cauldron"},
  "470": {"id": "n02948072", "label": "candle, taper, wax light"},
  "471": {"id": "n02950826", "label": "cannon"},
  "472": {"id": "n02951358", "label": "canoe"},
  "473": {"id": "n02951585", "label": "can opener, tin opener"},
  "474": {"id": "n02963159", "label": "cardigan"},
  "475": {"id": "n02965783", "label": "car mirror"},
  "476": {"id": "n02966193", "label": "carousel, carrousel, merry-go-round, roundabout, whirligig"},
  "477": {"id": "n02966687", "label": "carpenter's kit, tool kit"},
  "478": {"id": "n02971356", "label": "carton"},
  "479": {"id": "n02974003", "label": "car wheel"},
  "480": {
    "id": "n02977058",
    "label": "cash machine, cash dispenser, automated teller machine, autatic teller machine automated teller, automatic teller, ATM"},
  "481": {"id": "n02978881", "label": "cassette"},
  "482": {"id": "n02979186", "label": "cassette player"},
  "483": {"id": "n02980441", "label": "castle"},
  "484": {"id": "n02981792", "label": "catamaran"},
  "485": {"id": "n02988304", "label": "CD player"},
  "486": {"id": "n02992211", "label": "cello, violoncello"},
  "487": {"id": "n02992529", "label": "cellular telephone, cellular phone, cellphone, cell, mobile phone"},
  "488": {"id": "n02999410", "label": "chain"},
  "489": {"id": "n03000134", "label": "chainlink fence"},
  "490": {"id": "n03000247", "label": "chain mail, ring mail, mail, chain armor, chain armour, ring armor, ring armour"},
  "491": {"id": "n03000684", "label": "chain saw, chainsaw"},
  "492": {"id": "n03014705", "label": "chest"},
  "493": {"id": "n03016953", "label": "chiffonier, commode"},
  "494": {"id": "n03017168", "label": "chime, bell, gong"},
  "495": {"id": "n03018349", "label": "china cabinet, china closet"},
  "496": {"id": "n03026506", "label": "Christmas stocking"},
  "497": {"id": "n03028079", "label": "church, church building"},
  "498": {"id": "n03032252", "label": "cinema, movie theater, movie theatre, movie house, picture palace"},
  "499": {"id": "n03041632", "label": "cleaver, meat cleaver, chopper"},
  "500": {"id": "n03042490", "label": "cliff dwelling"},
  "501": {"id": "n03045698", "label": "cloak"},
  "502": {"id": "n03047690", "label": "clog, geta, patten, sabot"},
  "503": {"id": "n03062245", "label": "cocktail shaker"},
  "504": {"id": "n03063599", "label": "coffee mug"},
  "505": {"id": "n03063689", "label": "coffeepot"},
  "506": {"id": "n03065424", "label": "coil, spiral, volute, whorl, helix"},
  "507": {"id": "n03075370", "label": "combination lock"},
  "508": {"id": "n03085013", "label": "computer keyboard, keypad"},
  "509": {"id": "n03089624", "label": "confectionery, confectionary, candy store"},
  "510": {"id": "n03095699", "label": "container ship, containership, container vessel"},
  "511": {"id": "n03100240", "label": "convertible"},
  "512": {"id": "n03109150", "label": "corkscrew, bottle screw"},
  "513": {"id": "n03110669", "label": "cornet, horn, trumpet, trump"},
  "514": {"id": "n03124043", "label": "cowboy boot"},
  "515": {"id": "n03124170", "label": "cowboy hat, ten-gallon hat"},
  "516": {"id": "n03125729", "label": "cradle"},
  "517": {"id": "n03126707", "label": "crane"},
  "518": {"id": "n03127747", "label": "crash helmet"},
  "519": {"id": "n03127925", "label": "crate"},
  "520": {"id": "n03131574", "label": "crib, cot"},
  "521": {"id": "n03133878", "label": "Crock Pot"},
  "522": {"id": "n03134739", "label": "croquet ball"},
  "523": {"id": "n03141823", "label": "crutch"},
  "524": {"id": "n03146219", "label": "cuirass"},
  "525": {"id": "n03160309", "label": "dam, dike, dyke"},
  "526": {"id": "n03179701", "label": "desk"},
  "527": {"id": "n03180011", "label": "desktop computer"},
  "528": {"id": "n03187595", "label": "dial telephone, dial phone"},
  "529": {"id": "n03188531", "label": "diaper, nappy, napkin"},
  "530": {"id": "n03196217", "label": "digital clock"},
  "531": {"id": "n03197337", "label": "digital watch"},
  "532": {"id": "n03201208", "label": "dining table, board"},
  "533": {"id": "n03207743", "label": "dishrag, dishcloth"},
  "534": {"id": "n03207941", "label": "dishwasher, dish washer, dishwashing machine"},
  "535": {"id": "n03208938", "label": "disk brake, disc brake"},
  "536": {"id": "n03216828", "label": "dock, dockage, docking facility"},
  "537": {"id": "n03218198", "label": "dogsled, dog sled, dog sleigh"},
  "538": {"id": "n03220513", "label": "dome"},
  "539": {"id": "n03223299", "label": "doormat, welcome mat"},
  "540": {"id": "n03240683", "label": "drilling platform, offshore rig"},
  "541": {"id": "n03249569", "label": "drum, membranophone, tympan"},
  "542": {"id": "n03250847", "label": "drumstick"},
  "543": {"id": "n03255030", "label": "dumbbell"},
  "544": {"id": "n03259280", "label": "Dutch oven"},
  "545": {"id": "n03271574", "label": "electric fan, blower"},
  "546": {"id": "n03272010", "label": "electric guitar"},
  "547": {"id": "n03272562", "label": "electric locomotive"},
  "548": {"id": "n03290653", "label": "entertainment center"},
  "549": {"id": "n03291819", "label": "envelope"},
  "550": {"id": "n03297495", "label": "espresso maker"},
  "551": {"id": "n03314780", "label": "face powder"},
  "552": {"id": "n03325584", "label": "feather boa, boa"},
  "553": {"id": "n03337140", "label": "file, file cabinet, filing cabinet"},
  "554": {"id": "n03344393", "label": "fireboat"},
  "555": {"id": "n03345487", "label": "fire engine, fire truck"},
  "556": {"id": "n03347037", "label": "fire screen, fireguard"},
  "557": {"id": "n03355925", "label": "flagpole, flagstaff"},
  "558": {"id": "n03372029", "label": "flute, transverse flute"},
  "559": {"id": "n03376595", "label": "folding chair"},
  "560": {"id": "n03379051", "label": "football helmet"},
  "561": {"id": "n03384352", "label": "forklift"},
  "562": {"id": "n03388043", "label": "fountain"},
  "563": {"id": "n03388183", "label": "fountain pen"},
  "564": {"id": "n03388549", "label": "four-poster"},
  "565": {"id": "n03393912", "label": "freight car"},
  "566": {"id": "n03394916", "label": "French horn, horn"},
  "567": {"id": "n03400231", "label": "frying pan, frypan, skillet"},
  "568": {"id": "n03404251", "label": "fur coat"},
  "569": {"id": "n03417042", "label": "garbage truck, dustcart"},
  "570": {"id": "n03424325", "label": "gasmask, respirator, gas helmet"},
  "571": {"id": "n03425413", "label": "gas pump, gasoline pump, petrol pump, island dispenser"},
  "572": {"id": "n03443371", "label": "goblet"},
  "573": {"id": "n03444034", "label": "go-kart"},
  "574": {"id": "n03445777", "label": "golf ball"},
  "575": {"id": "n03445924", "label": "golfcart, golf cart"},
  "576": {"id": "n03447447", "label": "gondola"},
  "577": {"id": "n03447721", "label": "gong, tam-tam"},
  "578": {"id": "n03450230", "label": "gown"},
  "579": {"id": "n03452741", "label": "grand piano, grand"},
  "580": {"id": "n03457902", "label": "greenhouse, nursery, glasshouse"},
  "581": {"id": "n03459775", "label": "grille, radiator grille"},
  "582": {"id": "n03461385", "label": "grocery store, grocery, food market, market"},
  "583": {"id": "n03467068", "label": "guillotine"},
  "584": {"id": "n03476684", "label": "hair slide"},
  "585": {"id": "n03476991", "label": "hair spray"},
  "586": {"id": "n03478589", "label": "half track"},
  "587": {"id": "n03481172", "label": "hammer"},
  "588": {"id": "n03482405", "label": "hamper"},
  "589": {"id": "n03483316", "label": "hand blower, blow dryer, blow drier, hair dryer, hair drier"},
  "590": {"id": "n03485407", "label": "hand-held computer, hand-held microcomputer"},
  "591": {"id": "n03485794", "label": "handkerchief, hankie, hanky, hankey"},
  "592": {"id": "n03492542", "label": "hard disc, hard disk, fixed disk"},
  "593": {"id": "n03494278", "label": "harmonica, mouth organ, harp, mouth harp"},
  "594": {"id": "n03495258", "label": "harp"},
  "595": {"id": "n03496892", "label": "harvester, reaper"},
  "596": {"id": "n03498962", "label": "hatchet"},
  "597": {"id": "n03527444", "label": "holster"},
  "598": {"id": "n03529860", "label": "home theater, home theatre"},
  "599": {"id": "n03530642", "label": "honeycomb"},
  "600": {"id": "n03532672", "label": "hook, claw"},
  "601": {"id": "n03534580", "label": "hoopskirt, crinoline"},
  "602": {"id": "n03535780", "label": "horizontal bar, high bar"},
  "603": {"id": "n03538406", "label": "horse cart, horse-cart"},
  "604": {"id": "n03544143", "label": "hourglass"},
  "605": {"id": "n03584254", "label": "iPod"},
  "606": {"id": "n03584829", "label": "iron, smoothing iron"},
  "607": {"id": "n03590841", "label": "jack-o'-lantern"},
  "608": {"id": "n03594734", "label": "jean, blue jean, denim"},
  "609": {"id": "n03594945", "label": "jeep, landrover"},
  "610": {"id": "n03595614", "label": "jersey, T-shirt, tee shirt"},
  "611": {"id": "n03598930", "label": "jigsaw puzzle"},
  "612": {"id": "n03599486", "label": "jinrikisha, ricksha, rickshaw"},
  "613": {"id": "n03602883", "label": "joystick"},
  "614": {"id": "n03617480", "label": "kimono"},
  "615": {"id": "n03623198", "label": "knee pad"},
  "616": {"id": "n03627232", "label": "knot"},
  "617": {"id": "n03630383", "label": "lab coat, laboratory coat"},
  "618": {"id": "n03633091", "label": "ladle"},
  "619": {"id": "n03637318", "label": "lampshade, lamp shade"},
  "620": {"id": "n03642806", "label": "laptop, laptop computer"},
  "621": {"id": "n03649909", "label": "lawn mower, mower"},
  "622": {"id": "n03657121", "label": "lens cap, lens cover"},
  "623": {"id": "n03658185", "label": "letter opener, paper knife, paperknife"},
  "624": {"id": "n03661043", "label": "library"},
  "625": {"id": "n03662601", "label": "lifeboat"},
  "626": {"id": "n03666591", "label": "lighter, light, igniter, ignitor"},
  "627": {"id": "n03670208", "label": "limousine, limo"},
  "628": {"id": "n03673027", "label": "liner, ocean liner"},
  "629": {"id": "n03676483", "label": "lipstick, lip rouge"},
  "630": {"id": "n03680355", "label": "Loafer"},
  "631": {"id": "n03690938", "label": "lotion"},
  "632": {"id": "n03691459", "label": "loudspeaker, speaker, speaker unit, loudspeaker system, speaker system"},
  "633": {"id": "n03692522", "label": "loupe, jeweler's loupe"},
  "634": {"id": "n03697007", "label": "lumbermill, sawmill"},
  "635": {"id": "n03706229", "label": "magnetic compass"},
  "636": {"id": "n03709823", "label": "mailbag, postbag"},
  "637": {"id": "n03710193", "label": "mailbox, letter box"},
  "638": {"id": "n03710637", "label": "maillot"},
  "639": {"id": "n03710721", "label": "maillot, tank suit"},
  "640": {"id": "n03717622", "label": "manhole cover"},
  "641": {"id": "n03720891", "label": "maraca"},
  "642": {"id": "n03721384", "label": "marimba, xylophone"},
  "643": {"id": "n03724870", "label": "mask"},
  "644": {"id": "n03729826", "label": "matchstick"},
  "645": {"id": "n03733131", "label": "maypole"},
  "646": {"id": "n03733281", "label": "maze, labyrinth"},
  "647": {"id": "n03733805", "label": "measuring cup"},
  "648": {"id": "n03742115", "label": "medicine chest, medicine cabinet"},
  "649": {"id": "n03743016", "label": "megalith, megalithic structure"},
  "650": {"id": "n03759954", "label": "microphone, mike"},
  "651": {"id": "n03761084", "label": "microwave, microwave oven"},
  "652": {"id": "n03763968", "label": "military uniform"},
  "653": {"id": "n03764736", "label": "milk can"},
  "654": {"id": "n03769881", "label": "minibus"},
  "655": {"id": "n03770439", "label": "miniskirt, mini"},
  "656": {"id": "n03770679", "label": "minivan"},
  "657": {"id": "n03773504", "label": "missile"},
  "658": {"id": "n03775071", "label": "mitten"},
  "659": {"id": "n03775546", "label": "mixing bowl"},
  "660": {"id": "n03776460", "label": "mobile home, manufactured home"},
  "661": {"id": "n03777568", "label": "Model T"},
  "662": {"id": "n03777754", "label": "modem"},
  "663": {"id": "n03781244", "label": "monastery"},
  "664": {"id": "n03782006", "label": "monitor"},
  "665": {"id": "n03785016", "label": "moped"},
  "666": {"id": "n03786901", "label": "mortar"},
  "667": {"id": "n03787032", "label": "mortarboard"},
  "668": {"id": "n03788195", "label": "mosque"},
  "669": {"id": "n03788365", "label": "mosquito net"},
  "670": {"id": "n03791053", "label": "motor scooter, scooter"},
  "671": {"id": "n03792782", "label": "mountain bike, all-terrain bike, off-roader"},
  "672": {"id": "n03792972", "label": "mountain tent"},
  "673": {"id": "n03793489", "label": "mouse, computer mouse"},
  "674": {"id": "n03794056", "label": "mousetrap"},
  "675": {"id": "n03796401", "label": "moving van"},
  "676": {"id": "n03803284", "label": "muzzle"},
  "677": {"id": "n03804744", "label": "nail"},
  "678": {"id": "n03814639", "label": "neck brace"},
  "679": {"id": "n03814906", "label": "necklace"},
  "680": {"id": "n03825788", "label": "nipple"},
  "681": {"id": "n03832673", "label": "notebook, notebook computer"},
  "682": {"id": "n03837869", "label": "obelisk"},
  "683": {"id": "n03838899", "label": "oboe, hautboy, hautbois"},
  "684": {"id": "n03840681", "label": "ocarina, sweet potato"},
  "685": {"id": "n03841143", "label": "odometer, hodometer, mileometer, milometer"},
  "686": {"id": "n03843555", "label": "oil filter"},
  "687": {"id": "n03854065", "label": "organ, pipe organ"},
  "688": {"id": "n03857828", "label": "oscilloscope, scope, cathode-ray oscilloscope, CRO"},
  "689": {"id": "n03866082", "label": "overskirt"},
  "690": {"id": "n03868242", "label": "oxcart"},
  "691": {"id": "n03868863", "label": "oxygen mask"},
  "692": {"id": "n03871628", "label": "packet"},
  "693": {"id": "n03873416", "label": "paddle, boat paddle"},
  "694": {"id": "n03874293", "label": "paddlewheel, paddle wheel"},
  "695": {"id": "n03874599", "label": "padlock"},
  "696": {"id": "n03876231", "label": "paintbrush"},
  "697": {"id": "n03877472", "label": "pajama, pyjama, pj's, jammies"},
  "698": {"id": "n03877845", "label": "palace"},
  "699": {"id": "n03884397", "label": "panpipe, pandean pipe, syrinx"},
  "700": {"id": "n03887697", "label": "paper towel"},
  "701": {"id": "n03888257", "label": "parachute, chute"},
  "702": {"id": "n03888605", "label": "parallel bars, bars"},
  "703": {"id": "n03891251", "label": "park bench"},
  "704": {"id": "n03891332", "label": "parking meter"},
  "705": {"id": "n03895866", "label": "passenger car, coach, carriage"},
  "706": {"id": "n03899768", "label": "patio, terrace"},
  "707": {"id": "n03902125", "label": "pay-phone, pay-station"},
  "708": {"id": "n03903868", "label": "pedestal, plinth, footstall"},
  "709": {"id": "n03908618", "label": "pencil box, pencil case"},
  "710": {"id": "n03908714", "label": "pencil sharpener"},
  "711": {"id": "n03916031", "label": "perfume, essence"},
  "712": {"id": "n03920288", "label": "Petri dish"},
  "713": {"id": "n03924679", "label": "photocopier"},
  "714": {"id": "n03929660", "label": "pick, plectrum, plectron"},
  "715": {"id": "n03929855", "label": "pickelhaube"},
  "716": {"id": "n03930313", "label": "picket fence, paling"},
  "717": {"id": "n03930630", "label": "pickup, pickup truck"},
  "718": {"id": "n03933933", "label": "pier"},
  "719": {"id": "n03935335", "label": "piggy bank, penny bank"},
  "720": {"id": "n03937543", "label": "pill bottle"},
  "721": {"id": "n03938244", "label": "pillow"},
  "722": {"id": "n03942813", "label": "ping-pong ball"},
  "723": {"id": "n03944341", "label": "pinwheel"},
  "724": {"id": "n03947888", "label": "pirate, pirate ship"},
  "725": {"id": "n03950228", "label": "pitcher, ewer"},
  "726": {"id": "n03954731", "label": "plane, carpenter's plane, woodworking plane"},
  "727": {"id": "n03956157", "label": "planetarium"},
  "728": {"id": "n03958227", "label": "plastic bag"},
  "729": {"id": "n03961711", "label": "plate rack"},
  "730": {"id": "n03967562", "label": "plow, plough"},
  "731": {"id": "n03970156", "label": "plunger, plumber's helper"},
  "732": {"id": "n03976467", "label": "Polaroid camera, Polaroid Land camera"},
  "733": {"id": "n03976657", "label": "pole"},
  "734": {"id": "n03977966", "label": "police van, police wagon, paddy wagon, patrol wagon, wagon, black Maria"},
  "735": {"id": "n03980874", "label": "poncho"},
  "736": {"id": "n03982430", "label": "pool table, billiard table, snooker table"},
  "737": {"id": "n03983396", "label": "pop bottle, soda bottle"},
  "738": {"id": "n03991062", "label": "pot, flowerpot"},
  "739": {"id": "n03992509", "label": "potter'ss wheel"},
  "740": {"id": "n03995372", "label": "power drill"},
  "741": {"id": "n03998194", "label": "prayer rug, prayer mat"},
  "742": {"id": "n04004767", "label": "printer"},
  "743": {"id": "n04005630", "label": "prison, prison house"},
  "744": {"id": "n04008634", "label": "projectile, missile"},
  "745": {"id": "n04009552", "label": "projector"},
  "746": {"id": "n04019541", "label": "puck, hockey puck"},
  "747": {"id": "n04023962", "label": "punching bag, punch bag, punching ball, punchball"},
  "748": {"id": "n04026417", "label": "purse"},
  "749": {"id": "n04033901", "label": "quill, quill pen"},
  "750": {"id": "n04033995", "label": "quilt, comforter, comfort, puff"},
  "751": {"id": "n04037443", "label": "racer, race car, racing car"},
  "752": {"id": "n04039381", "label": "racket, racquet"},
  "753": {"id": "n04040759", "label": "radiator"},
  "754": {"id": "n04041544", "label": "radio, wireless"},
  "755": {"id": "n04044716", "label": "radio telescope, radio reflector"},
  "756": {"id": "n04049303", "label": "rain barrel"},
  "757": {"id": "n04065272", "label": "recreational vehicle, RV, R.V."},
  "758": {"id": "n04067472", "label": "reel"},
  "759": {"id": "n04069434", "label": "reflex camera"},
  "760": {"id": "n04070727", "label": "refrigerator, icebox"},
  "761": {"id": "n04074963", "label": "remote control, remote"},
  "762": {"id": "n04081281", "label": "restaurant, eating house, eating place, eatery"},
  "763": {"id": "n04086273", "label": "revolver, six-gun, six-shooter"},
  "764": {"id": "n04090263", "label": "rifle"},
  "765": {"id": "n04099969", "label": "rocking chair, rocker"},
  "766": {"id": "n04111531", "label": "rotisserie"},
  "767": {"id": "n04116512", "label": "rubber eraser, rubber, pencil eraser"},
  "768": {"id": "n04118538", "label": "rugby ball"},
  "769": {"id": "n04118776", "label": "rule, ruler"},
  "770": {"id": "n04120489", "label": "running shoe"},
  "771": {"id": "n04125021", "label": "safe"},
  "772": {"id": "n04127249", "label": "safety pin"},
  "773": {"id": "n04131690", "label": "saltshaker, salt shaker"},
  "774": {"id": "n04133789", "label": "sandal"},
  "775": {"id": "n04136333", "label": "sarong"},
  "776": {"id": "n04141076", "label": "sax, saxophone"},
  "777": {"id": "n04141327", "label": "scabbard"},
  "778": {"id": "n04141975", "label": "scale, weighing machine"},
  "779": {"id": "n04146614", "label": "school bus"},
  "780": {"id": "n04147183", "label": "schooner"},
  "781": {"id": "n04149813", "label": "scoreboard"},
  "782": {"id": "n04152593", "label": "screen, CRT screen"},
  "783": {"id": "n04153751", "label": "screw"},
  "784": {"id": "n04154565", "label": "screwdriver"},
  "785": {"id": "n04162706", "label": "seat belt, seatbelt"},
  "786": {"id": "n04179913", "label": "sewing machine"},
  "787": {"id": "n04192698", "label": "shield, buckler"},
  "788": {"id": "n04200800", "label": "shoe shop, shoe-shop, shoe store"},
  "789": {"id": "n04201297", "label": "shoji"},
  "790": {"id": "n04204238", "label": "shopping basket"},
  "791": {"id": "n04204347", "label": "shopping cart"},
  "792": {"id": "n04208210", "label": "shovel"},
  "793": {"id": "n04209133", "label": "shower cap"},
  "794": {"id": "n04209239", "label": "shower curtain"},
  "795": {"id": "n04228054", "label": "ski"},
  "796": {"id": "n04229816", "label": "ski mask"},
  "797": {"id": "n04235860", "label": "sleeping bag"},
  "798": {"id": "n04238763", "label": "slide rule, slipstick"},
  "799": {"id": "n04239074", "label": "sliding door"},
  "800": {"id": "n04243546", "label": "slot, one-armed bandit"},
  "801": {"id": "n04251144", "label": "snorkel"},
  "802": {"id": "n04252077", "label": "snowmobile"},
  "803": {"id": "n04252225", "label": "snowplow, snowplough"},
  "804": {"id": "n04254120", "label": "soap dispenser"},
  "805": {"id": "n04254680", "label": "soccer ball"},
  "806": {"id": "n04254777", "label": "sock"},
  "807": {"id": "n04258138", "label": "solar dish, solar collector, solar furnace"},
  "808": {"id": "n04259630", "label": "sombrero"},
  "809": {"id": "n04263257", "label": "soup bowl"},
  "810": {"id": "n04264628", "label": "space bar"},
  "811": {"id": "n04265275", "label": "space heater"},
  "812": {"id": "n04266014", "label": "space shuttle"},
  "813": {"id": "n04270147", "label": "spatula"},
  "814": {"id": "n04273569", "label": "speedboat"},
  "815": {"id": "n04275548", "label": "spider web, spider's web"},
  "816": {"id": "n04277352", "label": "spindle"},
  "817": {"id": "n04285008", "label": "sports car, sport car"},
  "818": {"id": "n04286575", "label": "spotlight, spot"},
  "819": {"id": "n04296562", "label": "stage"},
  "820": {"id": "n04310018", "label": "steam locomotive"},
  "821": {"id": "n04311004", "label": "steel arch bridge"},
  "822": {"id": "n04311174", "label": "steel drum"},
  "823": {"id": "n04317175", "label": "stethoscope"},
  "824": {"id": "n04325704", "label": "stole"},
  "825": {"id": "n04326547", "label": "stone wall"},
  "826": {"id": "n04328186", "label": "stopwatch, stop watch"},
  "827": {"id": "n04330267", "label": "stove"},
  "828": {"id": "n04332243", "label": "strainer"},
  "829": {"id": "n04335435", "label": "streetcar, tram, tramcar, trolley, trolley car"},
  "830": {"id": "n04336792", "label": "stretcher"},
  "831": {"id": "n04344873", "label": "studio couch, day bed"},
  "832": {"id": "n04346328", "label": "stupa, tope"},
  "833": {"id": "n04347754", "label": "submarine, pigboat, sub, U-boat"},
  "834": {"id": "n04350905", "label": "suit, suit of clothes"},
  "835": {"id": "n04355338", "label": "sundial"},
  "836": {"id": "n04355933", "label": "sunglass"},
  "837": {"id": "n04356056", "label": "sunglasses, dark glasses, shades"},
  "838": {"id": "n04357314", "label": "sunscreen, sunblock, sun blocker"},
  "839": {"id": "n04366367", "label": "suspension bridge"},
  "840": {"id": "n04367480", "label": "swab, swob, mop"},
  "841": {"id": "n04370456", "label": "sweatshirt"},
  "842": {"id": "n04371430", "label": "swimming trunks, bathing trunks"},
  "843": {"id": "n04371774", "label": "swing"},
  "844": {"id": "n04372370", "label": "switch, electric switch, electrical switch"},
  "845": {"id": "n04376876", "label": "syringe"},
  "846": {"id": "n04380533", "label": "table lamp"},
  "847": {"id": "n04389033", "label": "tank, army tank, armored combat vehicle, armoured combat vehicle"},
  "848": {"id": "n04392985", "label": "tape player"},
  "849": {"id": "n04398044", "label": "teapot"},
  "850": {"id": "n04399382", "label": "teddy, teddy bear"},
  "851": {"id": "n04404412", "label": "television, television system"},
  "852": {"id": "n04409515", "label": "tennis ball"},
  "853": {"id": "n04417672", "label": "thatch, thatched roof"},
  "854": {"id": "n04418357", "label": "theater curtain, theatre curtain"},
  "855": {"id": "n04423845", "label": "thimble"},
  "856": {"id": "n04428191", "label": "thresher, thrasher, threshing machine"},
  "857": {"id": "n04429376", "label": "throne"},
  "858": {"id": "n04435653", "label": "tile roof"},
  "859": {"id": "n04442312", "label": "toaster"},
  "860": {"id": "n04443257", "label": "tobacco shop, tobacconist shop, tobacconist"},
  "861": {"id": "n04447861", "label": "toilet seat"},
  "862": {"id": "n04456115", "label": "torch"},
  "863": {"id": "n04458633", "label": "totem pole"},
  "864": {"id": "n04461696", "label": "tow truck, tow car, wrecker"},
  "865": {"id": "n04462240", "label": "toyshop"},
  "866": {"id": "n04465501", "label": "tractor"},
  "867": {"id": "n04467665", "label": "trailer truck, tractor trailer, trucking rig, rig, articulated lorry, semi"},
  "868": {"id": "n04476259", "label": "tray"},
  "869": {"id": "n04479046", "label": "trench coat"},
  "870": {"id": "n04482393", "label": "tricycle, trike, velocipede"},
  "871": {"id": "n04483307", "label": "trimaran"},
  "872": {"id": "n04485082", "label": "tripod"},
  "873": {"id": "n04486054", "label": "triumphal arch"},
  "874": {"id": "n04487081", "label": "trolleybus, trolley coach, trackless trolley"},
  "875": {"id": "n04487394", "label": "trombone"},
  "876": {"id": "n04493381", "label": "tub, vat"},
  "877": {"id": "n04501370", "label": "turnstile"},
  "878": {"id": "n04505470", "label": "typewriter keyboard"},
  "879": {"id": "n04507155", "label": "umbrella"},
  "880": {"id": "n04509417", "label": "unicycle, monocycle"},
  "881": {"id": "n04515003", "label": "upright, upright piano"},
  "882": {"id": "n04517823", "label": "vacuum, vacuum cleaner"},
  "883": {"id": "n04522168", "label": "vase"},
  "884": {"id": "n04523525", "label": "vault"},
  "885": {"id": "n04525038", "label": "velvet"},
  "886": {"id": "n04525305", "label": "vending machine"},
  "887": {"id": "n04532106", "label": "vestment"},
  "888": {"id": "n04532670", "label": "viaduct"},
  "889": {"id": "n04536866", "label": "violin, fiddle"},
  "890": {"id": "n04540053", "label": "volleyball"},
  "891": {"id": "n04542943", "label": "waffle iron"},
  "892": {"id": "n04548280", "label": "wall clock"},
  "893": {"id": "n04548362", "label": "wallet, billfold, notecase, pocketbook"},
  "894": {"id": "n04550184", "label": "wardrobe, closet, press"},
  "895": {"id": "n04552348", "label": "warplane, military plane"},
  "896": {"id": "n04553703", "label": "washbasin, handbasin, washbowl, lavabo, wash-hand basin"},
  "897": {"id": "n04554684", "label": "washer, automatic washer, washing machine"},
  "898": {"id": "n04557648", "label": "water bottle"},
  "899": {"id": "n04560804", "label": "water jug"},
  "900": {"id": "n04562935", "label": "water tower"},
  "901": {"id": "n04579145", "label": "whiskey jug"},
  "902": {"id": "n04579432", "label": "whistle"},
  "903": {"id": "n04584207", "label": "wig"},
  "904": {"id": "n04589890", "label": "window screen"},
  "905": {"id": "n04590129", "label": "window shade"},
  "906": {"id": "n04591157", "label": "Windsor tie"},
  "907": {"id": "n04591713", "label": "wine bottle"},
  "908": {"id": "n04592741", "label": "wing"},
  "909": {"id": "n04596742", "label": "wok"},
  "910": {"id": "n04597913", "label": "wooden spoon"},
  "911": {"id": "n04599235", "label": "wool, woolen, woollen"},
  "912": {"id": "n04604644", "label": "worm fence, snake fence, snake-rail fence, Virginia fence"},
  "913": {"id": "n04606251", "label": "wreck"},
  "914": {"id": "n04612504", "label": "yawl"},
  "915": {"id": "n04613696", "label": "yurt"},
  "916": {"id": "n06359193", "label": "web site, website, internet site, site"},
  "917": {"id": "n06596364", "label": "comic book"},
  "918": {"id": "n06785654", "label": "crossword puzzle, crossword"},
  "919": {"id": "n06794110", "label": "street sign"},
  "920": {"id": "n06874185", "label": "traffic light, traffic signal, stoplight"},
  "921": {"id": "n07248320", "label": "book jacket, dust cover, dust jacket, dust wrapper"},
  "922": {"id": "n07565083", "label": "menu"},
  "923": {"id": "n07579787", "label": "plate"},
  "924": {"id": "n07583066", "label": "guacamole"},
  "925": {"id": "n07584110", "label": "consomme"},
  "926": {"id": "n07590611", "label": "hot pot, hotpot"},
  "927": {"id": "n07613480", "label": "trifle"},
  "928": {"id": "n07614500", "label": "ice cream, icecream"},
  "929": {"id": "n07615774", "label": "ice lolly, lolly, lollipop, popsicle"},
  "930": {"id": "n07684084", "label": "French loaf"},
  "931": {"id": "n07693725", "label": "bagel, beigel"},
  "932": {"id": "n07695742", "label": "pretzel"},
  "933": {"id": "n07697313", "label": "cheeseburger"},
  "934": {"id": "n07697537", "label": "hotdog, hot dog, red hot"},
  "935": {"id": "n07711569", "label": "mashed potato"},
  "936": {"id": "n07714571", "label": "head cabbage"},
  "937": {"id": "n07714990", "label": "broccoli"},
  "938": {"id": "n07715103", "label": "cauliflower"},
  "939": {"id": "n07716358", "label": "zucchini, courgette"},
  "940": {"id": "n07716906", "label": "spaghetti squash"},
  "941": {"id": "n07717410", "label": "acorn squash"},
  "942": {"id": "n07717556", "label": "butternut squash"},
  "943": {"id": "n07718472", "label": "cucumber, cuke"},
  "944": {"id": "n07718747", "label": "artichoke, globe artichoke"},
  "945": {"id": "n07720875", "label": "bell pepper"},
  "946": {"id": "n07730033", "label": "cardoon"},
  "947": {"id": "n07734744", "label": "mushroom"},
  "948": {"id": "n07742313", "label": "Granny Smith"},
  "949": {"id": "n07745940", "label": "strawberry"},
  "950": {"id": "n07747607", "label": "orange"},
  "951": {"id": "n07749582", "label": "lemon"},
  "952": {"id": "n07753113", "label": "fig"},
  "953": {"id": "n07753275", "label": "pineapple, ananas"},
  "954": {"id": "n07753592", "label": "banana"},
  "955": {"id": "n07754684", "label": "jackfruit, jak, jack"},
  "956": {"id": "n07760859", "label": "custard apple"},
  "957": {"id": "n07768694", "label": "pomegranate"},
  "958": {"id": "n07802026", "label": "hay"},
  "959": {"id": "n07831146", "label": "carbonara"},
  "960": {"id": "n07836838", "label": "chocolate sauce, chocolate syrup"},
  "961": {"id": "n07860988", "label": "dough"},
  "962": {"id": "n07871810", "label": "meat loaf, meatloaf"},
  "963": {"id": "n07873807", "label": "pizza, pizza pie"},
  "964": {"id": "n07875152", "label": "potpie"},
  "965": {"id": "n07880968", "label": "burrito"},
  "966": {"id": "n07892512", "label": "red wine"},
  "967": {"id": "n07920052", "label": "espresso"},
  "968": {"id": "n07930864", "label": "cup"},
  "969": {"id": "n07932039", "label": "eggnog"},
  "970": {"id": "n09193705", "label": "alp"},
  "971": {"id": "n09229709", "label": "bubble"},
  "972": {"id": "n09246464", "label": "cliff, drop, drop-off"},
  "973": {"id": "n09256479", "label": "coral reef"},
  "974": {"id": "n09288635", "label": "geyser"},
  "975": {"id": "n09332890", "label": "lakeside, lakeshore"},
  "976": {"id": "n09399592", "label": "promontory, headland, head, foreland"},
  "977": {"id": "n09421951", "label": "sandbar, sand bar"},
  "978": {"id": "n09428293", "label": "seashore, coast, seacoast, sea-coast"},
  "979": {"id": "n09468604", "label": "valley, vale"},
  "980": {"id": "n09472597", "label": "volcano"},
  "981": {"id": "n09835506", "label": "ballplayer, baseball player"},
  "982": {"id": "n10148035", "label": "groom, bridegroom"},
  "983": {"id": "n10565667", "label": "scuba diver"},
  "984": {"id": "n11879895", "label": "rapeseed"},
  "985": {"id": "n11939491", "label": "daisy"},
  "986": {"id": "n12057211", "label": "yellow lady's slipper, yellow lady-slipper, Cypripedium lceolus, Cypripediu parviflorum"},
  "987": {"id": "n12144580", "label": "corn"},
  "988": {"id": "n12267677", "label": "acorn"},
  "989": {"id": "n12620546", "label": "hip, rose hip, rosehip"},
  "990": {"id": "n12768682", "label": "buckeye, horse chestnut, conker"},
  "991": {"id": "n12985857", "label": "coral fungus"},
  "992": {"id": "n12998815", "label": "agaric"},
  "993": {"id": "n13037406", "label": "gyromitra"},
  "994": {"id": "n13040303", "label": "stinkhorn, carrion fungus"},
  "995": {"id": "n13044778", "label": "earthstar"},
  "996": {"id": "n13052670", "label": "hen-of-the-woods, hen of the woods, Polyporus frondosus, Grifola frondosa"},
  "997": {"id": "n13054560", "label": "bolete"},
  "998": {"id": "n13133613", "label": "ear, spike, capitulum"},
  "999": {"id": "n15075141", "label": "toilet tissue, toilet paper, bathroom tissue",
  }
}

